% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_train.R
\name{importance.train}
\alias{importance.train}
\title{Importance Plot for the caret::train objects}
\usage{
\method{importance}{train}(model_final, ...)
}
\arguments{
\item{model_final}{a model object}

\item{...}{arguments passed to other methods}
}
\value{
an object of type \code{importance_plot}
\item{type}{the type of importance plot}
\item{data}{the importance data required for the plot}
}
\description{
Importance Plot for the caret::train objects
}
\examples{
if (requireNamespace("caret", quietly = TRUE) &
    requireNamespace("randomForest", quietly = TRUE))
{
  model_final <- caret::train(x = subset(mtcars, select = -mpg), y = mtcars$mpg, method = "rf")
  imp <- importance(model_final)
  plot(imp)
}
}
\seealso{
\code{\link{importance}}
}
