% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTopicWord.R
\name{plotTopicWord}
\alias{plotTopicWord}
\title{Plotting Counts of Topics-Words-Combination over Time (Relative to Words)}
\usage{
plotTopicWord(object, docs, ldaresult, ldaID,
  wordlist = lda::top.topic.words(ldaresult$topics, 1), link = c("and",
  "or"), select = 1:nrow(ldaresult$document_sums), tnames, wnames,
  rel = FALSE, mark = TRUE, unit = "month", curves = c("exact",
  "smooth", "both"), smooth = 0.05, legend = ifelse(pages,
  "onlyLast:topright", "topright"), pages = FALSE, natozero = TRUE,
  file, main, xlab, ylab, ylim, both.lwd, both.lty, col, ...)
}
\arguments{
\item{object}{\code{\link{textmeta}} object with strictly tokenized
\code{text} component (Character vectors) - such as a result of
\code{\link{cleanTexts}}}

\item{docs}{Object as a result of \code{\link{LDAprep}} which was handed over
to \code{\link{LDAgen}}}

\item{ldaresult}{The result of a function call \code{\link{LDAgen}} with
\code{docs} as argument}

\item{ldaID}{Character vector of IDs of the documents in
\code{ldaresult}}

\item{wordlist}{List of Ccharacter vectors. Every list element is an 'or'
link, every character string in a vector is linked by the argument
\code{link}. If \code{wordlist} is only a character vector it will be
coerced to a list of the same length as the vector (see \code{\link{as.list}}),
so that the argument \code{link} has no effect. Each character vector
as a list element represents one curve in the emerging plot.}

\item{link}{Character: Should the (inner)
character vectors of each list element be linked by an \code{"and"}
or an \code{"or"} (default: \code{"and"})?}

\item{select}{List of integer vectors: Which topics - linked by an "or" every time -
should be take into account for plotting the
word counts/proportion (default: all topics as simple integer vector)?}

\item{tnames}{Character vector of same length as \code{select}
- labels for the topics (default are the first returned words of}

\item{wnames}{Character vector of same length as \code{wordlist}
- labels for every group of 'and' linked words
\code{\link{top.topic.words}} from the \code{lda} package for each topic)}

\item{rel}{Logical: Should counts
(\code{FALSE}) or proportion (\code{TRUE}) be plotted (default: \code{FALSE})?}

\item{mark}{Logical: Should years be marked by
vertical lines (default: \code{TRUE})?}

\item{unit}{Character: To which unit should dates be floored
(default: \code{"month"})? Other possible units are \code{"bimonth"}, \code{"quarter"}, \code{"season"},
\code{"halfyear"}, \code{"year"}, for more units see \code{\link[lubridate]{round_date}}}

\item{curves}{Character: Should \code{"exact"},
\code{"smooth"} curve or \code{"both"} be plotted (default: \code{"exact"})?}

\item{smooth}{Numeric: Smoothing parameter
which is handed over to \code{\link{lowess}} as \code{f} (default: \code{0.05})}

\item{legend}{Character: Value(s) to specify the legend coordinates (default: \code{"topright"},
\code{"onlyLast:topright"} for \code{pages = TRUE} respectively).
If "none" no legend is plotted.}

\item{pages}{Logical: Should all curves be
plotted in a single plot (default: \code{FALSE})? In addition you could set
\code{legend = "onlyLast:<argument>"} with \code{<argument>} as a
character \code{legend} argument
for only plotting a legend on the last plot of set.}

\item{natozero}{Logical: Should NAs be coerced
to zeros (default: \code{TRUE})?}

\item{file}{Character: File path if a pdf should be created}

\item{main}{Character: Graphical parameter}

\item{xlab}{Character: Graphical parameter}

\item{ylab}{Character: Graphical parameter}

\item{ylim}{Graphical parameter}

\item{both.lwd}{Graphical parameter for smoothed values
if \code{curves = "both"}}

\item{both.lty}{Graphical parameter for smoothed values
if \code{curves = "both"}}

\item{col}{Graphical parameter, could be a vector. If \code{curves = "both"}
the function will for every wordgroup plot at first the exact and then the
smoothed curve - this is important for your col order.}

\item{\dots}{Additional graphical parameters}
}
\value{
A plot.
Invisible: A dataframe with columns \code{date} and \code{tnames: wnames}
with the counts/proportion of the selected combination of topics and words.
}
\description{
Creates a plot of the counts/proportion of specified combination of topics
and words. It is important to keep in mind that the baseline for
proportions are the sums of words, not sums of topics.
See also \code{\link{plotWordpt}}.
There is an option to plot all curves in one plot or to create one plot for
every curve (see \code{pages}). In addition the plots can be written to a pdf
by setting \code{file}.
}
\examples{
\donttest{
data(politics)
poliClean <- cleanTexts(politics)
words10 <- makeWordlist(text=poliClean$text)
words10 <- words10$words[words10$wordtable > 10]
poliLDA <- LDAprep(text=poliClean$text, vocab=words10)
LDAresult <- LDAgen(documents=poliLDA, K=10, vocab=words10)

# plot topwords from each topic
plotTopicWord(object=poliClean, docs=poliLDA, ldaresult=LDAresult, ldaID=names(poliLDA))
plotTopicWord(object=poliClean, docs=poliLDA, ldaresult=LDAresult, ldaID=names(poliLDA), rel=TRUE)

# plot one word in different topics
plotTopicWord(object=poliClean, docs=poliLDA, ldaresult=LDAresult, ldaID=names(poliLDA),
              select=c(1,3,8), wordlist=c("bush"))

# Differences between plotTopicWord and plotWordpt
par(mfrow=c(2,2))
plotTopicWord(object=poliClean, docs=poliLDA, ldaresult=LDAresult, ldaID=names(poliLDA),
              select=c(1,3,8), wordlist=c("bush"), rel=FALSE)
plotWordpt(object=poliClean, docs=poliLDA, ldaresult=LDAresult, ldaID=names(poliLDA),
           select=c(1,3,8), wordlist=c("bush"), rel=FALSE)
plotTopicWord(object=poliClean, docs=poliLDA, ldaresult=LDAresult, ldaID=names(poliLDA),
              select=c(1,3,8), wordlist=c("bush"), rel=TRUE)
plotWordpt(object=poliClean, docs=poliLDA, ldaresult=LDAresult, ldaID=names(poliLDA),
           select=c(1,3,8), wordlist=c("bush"), rel=TRUE)
}
}
