% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmeta.R
\name{textmeta}
\alias{textmeta}
\alias{is.textmeta}
\alias{print.textmeta}
\alias{summary.textmeta}
\alias{plot.textmeta}
\title{"textmeta"-Objects}
\usage{
textmeta(meta = NULL, text = NULL, metamult = NULL,
  dateFormat = "\%Y-\%m-\%d")

is.textmeta(x)

\method{print}{textmeta}(x, ...)

\method{summary}{textmeta}(object, listnames = names(object),
  metavariables = character(), ...)

\method{plot}{textmeta}(x, ...)
}
\arguments{
\item{meta}{Data.frame (or matrix) of the meta-data}

\item{text}{List (or character vector) of the text-data}

\item{metamult}{List of the metamult-data}

\item{dateFormat}{Charachter string with the date format in meta
for \code{\link{as.Date}}}

\item{x}{an R Object.}

\item{...}{further arguments in plot. Not implemented for print and summary.}

\item{object}{textmeta object}

\item{listnames}{Character vector with names of textmeta lists (meta, text, metamult). Summaries are generated for those lists only. Default gives summaries for all lists.}

\item{metavariables}{Character vector with variable-names from the meta dataset. Summaries are generated for those variables only.}
}
\value{
A \code{textmeta} object.
}
\description{
Creates, Tests, Summarises and Plots Textmeta-Objects
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

corpus <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

print(corpus)
summary(corpus)
str(corpus)

}
\keyword{manip}
