% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_polish.r
\name{search_polish}
\alias{search_polish}
\title{Search very locally to find slightly better projections to polish a broader search.}
\usage{
search_polish(
  current,
  alpha = 0.5,
  index,
  tries,
  polish_max_tries = 30,
  cur_index = NA,
  n_sample = 100,
  polish_cooling = 1,
  ...
)
}
\arguments{
\item{current}{the current projection basis}

\item{alpha}{the angle used to search the target basis from the current basis}

\item{index}{index function}

\item{tries}{the counter of the outer loop of the opotimiser}

\item{polish_max_tries}{maximum number of iteration before giving up}

\item{cur_index}{the index value of the current basis}

\item{n_sample}{number of samples to generate}

\item{polish_cooling}{percentage of reduction in polish_alpha when no better basis is found}

\item{...}{other arguments being passed into the \code{search_polish()}}
}
\description{
Search very locally to find slightly better projections to polish a broader search.
}
\examples{
set.seed(2020)
t1 <- save_history(flea[, 1:6], guided_tour(holes()), max = 100)
attr(t1, "class") <- NULL
best_proj <- t1[, , dim(t1)[3]]
animate_xy(
  flea[, 1:6],
  guided_tour(holes(),
    search_f = search_polish,
    cur_index = 0
  ),
  start = best_proj
)
}
\keyword{optimize}
