% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display-slice.r
\name{display_slice}
\alias{display_slice}
\alias{animate_slice}
\title{Display tour path with a sliced scatterplot}
\usage{
display_slice(
  center = TRUE,
  axes = "center",
  half_range = NULL,
  col = "black",
  pch_slice = 20,
  pch_other = 46,
  cex_slice = 2,
  cex_other = 1,
  v_rel = NULL,
  anchor = NULL,
  anchor_nav = "off",
  edges = NULL,
  edges.col = "black",
  palette = "Zissou 1",
  ...
)

animate_slice(data, tour_path = grand_tour(), rescale = FALSE, ...)
}
\arguments{
\item{center}{if TRUE, centers projected data to (0,0).  This pins the
center of data cloud and make it easier to focus on the changing shape
rather than position.}

\item{axes}{position of the axes: center, bottomleft or off}

\item{half_range}{half range to use when calculating limits of projected.
If not set, defaults to maximum distance from origin to each row of data.}

\item{col}{color to use for points, can be a vector or hexcolors or a factor.  Defaults to "black".}

\item{pch_slice}{marker for plotting points inside the slice.
Defaults to 20.}

\item{pch_other}{marker for plotting points outside the slice.
Defaults to 46.}

\item{cex_slice}{size of the points inside the slice. Defaults to 2.}

\item{cex_other}{size if the points outside the slice. Defaults to 1.}

\item{v_rel}{relative volume of the slice. If not set, suggested value
is calculated and printed to the screen.}

\item{anchor}{A vector specifying the reference point to anchor the slice.
If NULL (default) the slice will be anchored at the data center.}

\item{anchor_nav}{position of the anchor: center, topright or off}

\item{edges}{A two column integer matrix giving indices of ends of lines.}

\item{edges.col}{colour of edges to be plotted, Defaults to "black.}

\item{palette}{name of color palette for point colour, used by \code{\link{hcl.colors}}, default "Zissou 1"}

\item{...}{other arguments passed on to \code{\link{animate}} and
\code{\link{display_slice}}}

\item{data}{matrix, or data frame containing numeric columns}

\item{tour_path}{tour path generator, defaults to 2d grand tour}

\item{rescale}{Default FALSE. If TRUE, rescale all variables to range [0,1].}
}
\description{
Animate a 2D tour path with a sliced scatterplot.
}
\examples{
# Generate samples on a 3d and 5d hollow sphere using the geozoo package
sphere3 <- geozoo::sphere.hollow(3)$points
sphere5 <- geozoo::sphere.hollow(5)$points

# Columns need to be named before launching the tour
colnames(sphere3) <- c("x1", "x2", "x3")
colnames(sphere5) <- c("x1", "x2", "x3", "x4", "x5")

# Animate with the slice display using the default parameters
animate_slice(sphere3)
animate_slice(sphere5)

# Animate with off-center anchoring
anchor3 <- matrix(rep(0.7, 3), ncol=3)
anchor5 <- matrix(rep(0.3, 5), ncol=5)
animate_slice(sphere3, anchor = anchor3)
# Animate with thicker slice to capture more points in each view
animate_slice(sphere5, anchor = anchor5, v_rel = 0.02)
}
