% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_chemical_boxplots.R,
%   R/plot_group_boxplots.R, R/side_by_side.R
\name{graph_chem_data}
\alias{graph_chem_data}
\alias{tox_boxplot_data}
\alias{side_by_side_data}
\title{Prepare boxplot data}
\usage{
graph_chem_data(
  chemical_summary,
  ...,
  manual_remove = NULL,
  mean_logic = FALSE,
  sum_logic = TRUE
)

tox_boxplot_data(
  chemical_summary,
  category = "Biological",
  manual_remove = NULL,
  mean_logic = FALSE,
  sum_logic = TRUE
)

side_by_side_data(
  gd_left,
  gd_right,
  left_title = "Left",
  right_title = "Right"
)
}
\arguments{
\item{chemical_summary}{Data frame from \code{\link{get_chemical_summary}}.}

\item{...}{Additional group_by arguments. This can be handy for creating facet graphs.}

\item{manual_remove}{Vector of categories to remove.}

\item{mean_logic}{Logical. \code{TRUE} displays the mean sample from each site,
\code{FALSE} displays the maximum sample from each site.}

\item{sum_logic}{Logical. \code{TRUE} sums the EARs in a specified grouping,
\code{FALSE} does not. \code{FALSE} may be better for traditional benchmarks as
opposed to ToxCast benchmarks.}

\item{category}{Character. Either "Biological", "Chemical Class", or "Chemical".}

\item{gd_left}{Data frame that must include the columns chnm, Class, and either EAR or meanEAR.}

\item{gd_right}{Data frame that must include the columns chnm, Class, and either EAR or meanEAR.}

\item{left_title}{Character that will be associated with the "gd_left" data
frame in a column named "guide_side".}

\item{right_title}{Character that will be associated with the "gd_right" data
frame in a column named "guide_side".}
}
\description{
A set of functions to prepare the data for boxplots. Often, these
functions are used within the plotting functions. They are exported however
to allow custom graphs to be created.
}
\details{
The function side_by_side_data will combine two data frames,
either the output of \code{\link{get_chemical_summary}} or \code{\link{graph_chem_data}},
into a single data frame. The important work here is that the chemicals
and classes factor levels are ordered primarily based on "gd_left", but
include "gd_right" when the contents are mismatched.
}
\examples{
path_to_tox <- system.file("extdata", package = "toxEval")
file_name <- "OWC_data_fromSup.xlsx"
full_path <- file.path(path_to_tox, file_name)

tox_list <- create_toxEval(full_path)

ACC <- get_ACC(tox_list$chem_info$CAS)
ACC <- remove_flags(ACC)

cleaned_ep <- clean_endPoint_info(end_point_info)
filtered_ep <- filter_groups(cleaned_ep)

chemical_summary <- get_chemical_summary(tox_list, ACC, filtered_ep)
# Let's say we want to compare 2 chemical summaries
# We'll look at one summing EARs, and with concentrations
# First, we need a chemical summary for concentrations:
chemical_summary_conc <- get_concentration_summary(tox_list)

gd_tox <- graph_chem_data(chemical_summary)
gd_conc <- graph_chem_data(chemical_summary_conc)

ch_combo <- side_by_side_data(gd_tox, gd_conc,
  left_title = "ToxCast",
  right_title = "Concentrations"
)
plot_chemical_boxplots(ch_combo, guide_side,
  x_label = ""
) +
  ggplot2::facet_grid(. ~ guide_side, scales = "free_x")
}
