% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize_taxa}
\alias{standardize_taxa}
\alias{standardize.taxonomy}
\alias{standardise_taxa}
\title{Standardize scientific names of species}
\usage{
standardize_taxa(
  x,
  method = get_gbif_taxonomy,
  method_options = c(subspecies = TRUE, higherrank = FALSE, verbose = FALSE, fuzzy =
    TRUE, conf_threshold = 90, resolve_synonyms = TRUE),
  return = c("kingdom", "phylum", "class", "order", "family"),
  ...
)
}
\arguments{
\item{x}{a traitdata object (as returned by \code{as.traitdata()}) or a data table
containing at least the column `verbatimScientificName.}

\item{method}{default option is \code{get_gbif_taxonomy}. In principle, takes any
function that takes a vector of species names as input to produce a
taxonomy lookup table (i.e. mapping user-provided \code{verbatimScientificName}
to \code{taxonID} and other taxon-level information). Will allow to chose from
different sources of taxonomic reference.}

\item{method_options}{a name vector of arguments to be passed on to \code{method}.
See \link{get_gbif_taxonomy} for options.}

\item{return}{a character vector containing the informatoin that should be
extracted into the output. Valid entries are the column names returned by
function \code{get_gbif_taxonomy()}. See 'Details'.}

\item{...}{parameters to be ignored, forwarded from wrapper function
\code{standardize()}.}
}
\value{
A traidata object with standardized scientific taxon names according
to GBif Backbone taxonomy.
}
\description{
Adds columns to a traitdata object containing accepted species
names and relates to globally unique taxon identifiers via URI.
}
\details{
Taxonomic standardisation is an enormous challenge for biodiversity
data management and research. Constant changes in species and higher taxa,
refinements of phylogenetic trees and changing attribution to original
authors, moving species into other genera or difficulties to place species
into the Linean nomenclature results in highly fluctuent taxonomic
definitions.

As a consequence, there is not one reference for accepted species names and
depending on the field of resaerch and taxonomic focus other authorities
will be employed.

For reasons of simplicity and because of its high coverage of taxa, the
function \code{standardize.taxonomy()} uses the GBIF Backbone Taxonomy as its
reference system and resolves all provided species names to the accepted
name according to GBIF (resolving misspellings and synonyms in the
process). We invite pull requests to make this function more general and
enable a choice of a taxonomic reference.
}
\examples{

\dontrun{

pulldata("carabids")

dataset1 <- as.traitdata(carabids,
  taxa = "name_correct",
  traits = c("body_length", "antenna_length", "metafemur_length"),
  units = "mm",
  keep = c(datasetID = "source_measurement", measurementRemark = "note"),
  metadata = list(
    bibliographicCitation = attributes(carabids)$citeAs,
    author = "Fons van der Plas",
    license = "http://creativecommons.org/publicdomain/zero/1.0/"
    )
)

dataset1Std <- standardize_taxa(dataset1)
}
}
\seealso{
Other standardize: 
\code{\link{standardize_traits}()},
\code{\link{standardize}()}
}
\concept{standardize}
