% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_adequacy.R
\name{AvePP}
\alias{AvePP}
\title{Average Posterior Probability}
\usage{
AvePP(sol, Y, A, X = NULL)
}
\arguments{
\item{sol}{Trajectory's object. An object of type Trajectory.}

\item{Y}{Matrix. A matrix containing the variables in the model.}

\item{A}{Matrix. A matrix containing the time variable data.}

\item{X}{Matrix. An optional matrix that modifies the probability of belong to group.
By default its value is a one column matrix with value 1.}
}
\value{
A vector of reals. The average posterior probability.
}
\description{
Calculate the Average Posterior Probability. Average Posterior Probability
(AvePP) is the average posterior probability of membership for each group for
those individuals that were assigned to.
}
\examples{
data = read.csv(system.file("extdata", "CNORM2gr.csv", package = "trajeR"))
data = as.matrix(data)
sol = trajeR(Y = data[, 2:6], A = data[, 7:11], degre = c(2,2), Model = "CNORM", Method = "EM")
AvePP(sol, Y = data[, 2:6], A = data[, 7:11])
}
