% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gformula.R
\name{gformula}
\alias{gformula}
\title{Counterfactual means via G-Formula}
\usage{
gformula(
  formula,
  baseline,
  covariates,
  treatment,
  outcome,
  ntimes_interval,
  obsdata
)
}
\arguments{
\item{formula}{Specification of the model for the outcome to be fitted.}

\item{baseline}{Names of the baseline covariates.}

\item{covariates}{Names of the time-varying covariates (should be a list).}

\item{treatment}{Names of the time-varying treatment.}

\item{outcome}{Name of the outcome variable.}

\item{ntimes_interval}{Length of a time-interval (s).}

\item{obsdata}{Observed data in wide format.}
}
\value{
\item{list_gform_countermeans}{ List of counterfactual means obtained with g-formula.}
}
\description{
Calculates counterfactual means using the g-formula approach.
}
\examples{
\donttest{
obsdata = gendata(n = 1000, format = "wide", total_followup = 6, seed = 945)
years <- 2011:2016
baseline_var <- c("age","sex")
variables <- c("hyper", "bmi")
var_cov <- c("statins","hyper", "bmi")
covariates <- lapply(years, function(year) {
paste0(variables, year)})
treatment_var <- paste0("statins", 2011:2016)
formula = paste0("y ~", paste0(treatment_var,collapse = "+"), "+",
                paste0(unlist(covariates), collapse = "+"),"+",
                paste0(baseline_var, collapse = "+"))
res_gform <- gformula(formula = formula, baseline = baseline_var, covariates = covariates,
treatment = treatment_var, outcome = "y", ntimes_interval = 6, obsdata =   obsdata )
}
}
\author{
Awa Diop, Denis Talbot
}
