% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trReg.R
\name{trReg}
\alias{trReg}
\title{Fitting regression model via structural transformation model}
\usage{
trReg(formula, data, subset, tFun = "linear", method = c("kendall",
  "adjust"), B = 0, control = list())
}
\arguments{
\item{formula}{a formula expression, of the form \code{response ~ predictors}.
The \code{response} is assumed to be a \code{survival::Surv} object with both left truncation and right censoring.
See \code{?survival::Surv} for more details.}

\item{data}{an optional data.frame in which to interpret the variables occurring
in the \code{formula}.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{tFun}{a character string specifying the transformation function or a user specified function indicating the relationship between X, T, and a.
When \code{tFun} is a character, the following are permitted:
\describe{
  \item{linear}{linear transformation structure}
  \item{log}{log-linear transformation structure}
  \item{exp}{exponential transformation structure}
}}

\item{method}{a character string specifying the underlying model. See \bold{Details}.}

\item{B}{a numerical value specifies the bootstrap size.
When \code{B = 0}, the bootstrap standard errors will not be computed.}

\item{control}{ca list of control parameters. The following arguments are allowed:
\describe{
  \item{\code{lower}}{The lower bound to search for the transformation parameter; default at -1.}
  \item{\code{upper}}{The upper bound to search for the transformation parameter; default at 20.}
  \item{\code{tol}}{The tolerance used in the search for the transformation parameter; default at 0.01.}
  \item{\code{G}}{The number of grids used in the search for the transformation parameter; default at 50.
A smaller \code{G} could results in faster search, but might be inaccurate.}
  \item{\code{Q}}{The number of cutpoints for the truncation time used when \code{method = "adjust"}.}
  \item{\code{parallel}}{an logical value indicating whether parallel computation will be applied when \code{B} is not 0.}
  \item{\code{parCl}}{an integer value specifying the number of CPU cores to be used when \code{parallel = TRUE}.
The default value is half the CPU cores on the current host.}
}}
}
\description{
\code{trReg} fits transformation model under dependent truncation and independent censoring via a structural transformation model.
}
\examples{
library(survival)
data(channing, package = "boot")
chan <- subset(channing, entry < exit)
trReg(Surv(entry, exit, cens) ~ sex, data = chan)
trReg(Surv(entry, exit, cens) ~ sex, data = chan, method = "adjust", control = list(G = 10))

}
