% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{routes}
\alias{routes}
\title{Routes}
\usage{
routes(locations, departure_searches = NULL, arrival_searches = NULL)
}
\arguments{
\item{locations}{One or more objects created by \code{\link{make_location}}}

\item{departure_searches}{One or more objects created by \code{\link{make_search}}}

\item{arrival_searches}{One or more objects created by \code{\link{make_search}}}
}
\value{
API response parsed as a list and as a raw json
}
\description{
Returns routing information between source and destinations.
}
\details{
See \url{https://docs.traveltime.com/api/reference/routes/} for details
}
\examples{
\dontrun{
locations <- c(
  make_location(
    id = 'London center',
    coords = list(lat = 51.508930, lng = -0.131387)),
  make_location(
    id = 'Hyde Park',
    coords = list(lat = 51.508824, lng = -0.167093)),
  make_location(
    id = 'ZSL London Zoo',
    coords = list(lat = 51.536067, lng = -0.153596))
)

departure_search <-
  make_search(id = "departure search example",
              departure_location_id = "London center",
              arrival_location_ids = list("Hyde Park", "ZSL London Zoo"),
              departure_time = strftime(as.POSIXlt(Sys.time(), "UTC"), "\%Y-\%m-\%dT\%H:\%M:\%SZ"),
              transportation = list(type = "driving"),
              properties = list("travel_time", "distance", "route"))

arrival_search <-
  make_search(id = "arrival  search example",
              arrival_location_id = "London center",
              departure_location_ids = list("Hyde Park", "ZSL London Zoo"),
              arrival_time = strftime(as.POSIXlt(Sys.time(), "UTC"), "\%Y-\%m-\%dT\%H:\%M:\%SZ"),
              transportation = list(type = "public_transport"),
              properties = list('travel_time', "distance", "route", "fares"),
              range = list(enabled = TRUE, width = 1800, max_results = 1))

result <-
  routes(
    departure_searches = departure_search,
    arrival_searches = arrival_search,
    locations = locations
  )
}
}
