% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_correction_factors.R
\name{get_correction_factors}
\alias{get_correction_factors}
\title{Correction Factors for Tree Plot Areas Intersected by Stand Boundaries}
\usage{
get_correction_factors(angle_counts, boundaries, verbose = TRUE)
}
\arguments{
\item{angle_counts}{A \code{\link{data.frame}} containing angle counts.
It has to have columns named by the contents of
either\cr
\code{\link{get_defaults}("angle_counts")} or \cr
\code{fritools::get_options(package_name = "treePlotArea",
      flatten_list = FALSE )[["angle_counts"]]}.\cr
Could be
\code{bw2bwi2022de(get(data("trees", package = "treePlotArea")))}).}

\item{boundaries}{A \code{\link{data.frame}} containing boundaries.
It has to have columns named by the contents of
either\cr
\code{\link{get_defaults}("boundaries"} or \cr
\code{fritools::get_options(package_name = "treePlotArea",
      flatten_list = FALSE )[["boundaries"]]}.\cr
Could be
\code{get(data("boundaries", package = "treePlotArea"))} or the
output of
\code{\link{get_boundary_polygons}}.}

\item{verbose}{Be verbose?}
}
\value{
A  \code{\link{data.frame}} containing the correction factors.
}
\description{
Get correction factors for an angle count table (i.e. a
\code{\link{data.frame}}) and a corresponding boundary
table (i.e. a \code{\link{data.frame}}) .
}
\examples{
data("trees", "boundaries", package = "treePlotArea")
# For CRAN's sake draw a subset
tracts <-  c(sample(boundaries$tnr, 20), 10056)
trees <- subset(trees, tnr \%in\% tracts)
boundaries <- subset(boundaries, tnr \%in\% tracts)
angle_counts <- bw2bwi2022de(trees)
boundary_polygons <- get_boundary_polygons(boundaries)
correction_factors <- get_correction_factors(angle_counts, boundary_polygons)
# Select a single tree
tnr <- 10056
enr <- 4
bnr <- 3
tree <- angle_counts[angle_counts[["tnr"]] == tnr &
                     angle_counts[["enr"]] == enr &
                     angle_counts[["bnr"]] == bnr, TRUE]
bounds <- boundaries[boundaries[["tnr"]] == tnr & boundaries[["enr"]] == enr,
                     TRUE]
get_correction_factors(tree, bounds)
}
