% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/deprecated_sim_functions.R
\name{sim_stBD}
\alias{sim_stBD}
\alias{sim_sptree_bdp}
\title{Simulates species trees using constant rate birth-death process}
\usage{
sim_stBD(sbr, sdr, numbsim, n_tips, gsa_stop_mult = 10L)

sim_sptree_bdp(sbr, sdr, numbsim, n_tips, gsa_stop_mult = 10)
}
\arguments{
\item{sbr}{species birth rate (i.e. speciation rate)}

\item{sdr}{species death rate (i.e. extinction rate)}

\item{numbsim}{number of species trees to simulate}

\item{n_tips}{number of tips to simulate to}

\item{gsa_stop_mult}{number of tips to simulate the GSA tip to}
}
\value{
List of objects of the tree class (as implemented in APE)
}
\description{
Forward simulates to a number of tips. This function does so using
    the general algorithm of Hartmann et al. 2010. Short for simulate species tree under
    birth-death process.
}
\examples{
mu <- 0.5 # death rate
lambda <- 2.0 # birth rate
numb_replicates <- 10
numb_extant_tips <- 4
# simulate trees under the GSA so first simulates a tree with
# numb_extant_tips * 100 tips counting each time we have a tree with 10 tips
# then randomly picks one of those trees

tree_list <- sim_stBD(sbr = lambda,
                sdr = mu,
                numbsim = numb_replicates,
                n_tips = numb_extant_tips)
}
\references{
K. Hartmann, D. Wong, T. Stadler. Sampling trees from evolutionary models.
    Syst. Biol., 59(4): 465-476, 2010.

T. Stadler. Simulating trees on a fixed number of extant species.
    Syst. Biol., 60: 676-684, 2011.
}
