% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nd-methods.R
\name{getNdPrids}
\alias{getNdPrids}
\title{Get pre-nodes to root}
\usage{
getNdPrids(tree, id)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{id}{node id}
}
\description{
Return node ids for connecting \code{id} to root.
}
\details{
Returns a vector. IDs are returned order from node ID to root.
}
\examples{
library(treeman)
tree <- randTree(10)
# get all nodes to root
getNdPrids(tree, id='t1')
}
\seealso{
\code{\link{getNdsPrids}}, 
\code{\link{getNdPtids}}, 
\code{\link{getNdsPtids}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
