% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial.mk.test.R
\name{partial.mk.test}
\alias{partial.mk.test}
\title{Partial Mann-Kendall Trend Test}
\usage{
partial.mk.test(x, y, alternative = c("two.sided", "greater", "less"))
}
\arguments{
\item{x}{a "vector" or "ts" object that contains the variable,
which is tested for trend (i.e. correlated with time)}

\item{y}{a "vector" or "ts" object that contains the variable,
which effect on "x" is partialled out}

\item{alternative}{character, the alternative method; defaults to
"two.sided"}
}
\value{
A list with class "htest"

 \item{method}{
   a character string indicating the chosen test
 }
 \item{data.name}{
   a character string giving the name(s) of the data
 }
 \item{statistic}{
   	the value of the test statistic
 }
 \item{estimate}{
   the Mann-Kendall score S, the variance varS and the correlation
   between x and y
 }
 \item{alternative}{
   a character string describing the alternative hypothesis
 }
 \item{p.value}{
   the p-value of the test
 }
\item{null.value}{
the null hypothesis
}
}
\description{
Performs a partial Mann-Kendall Trend Test
}
\details{
According to Libiseller and Grimvall (2002), the test statistic
for \code{x} with its covariate \code{y} is

\deqn{
z = \frac{S_x - r_{xy} S_y}{\left[ \left( 1 - r_{xy}^2 \right)
n \left(n - 1 \right) \left(2 n + 5 \right) / 18 \right]^{0.5}}}{%
z = (S[x] - r * S[y]) / \sqrt(1 - r^2) *
n * (n - 1) * (2 * n + 5) / 18)}

where the correlation \eqn{r} is calculated as:

\deqn{
r_{xy} = \frac{\sigma_{xy}}
{n \left(n - 1\right) \left(2 n + 5 \right) / 18}
}{%
r = \sigma /
(n (n - 1) (2n + 5) / 18)}

The conditional covariance between \eqn{x} and \eqn{y} is

\deqn{
\sigma_{xy} = \frac{1}{3}
\left[K + 4 \sum_{j=1}^n R_{jx} R_{jy} -
n \left(n + 1 \right) \left(n + 1 \right) \right]}

with

\deqn{
K = \sum_{1 \le i < j \le n} \mathrm{sgn} \left\{ \left( x_j - x_i \right)
\left( y_j - y_i \right) \right\}}

and

\deqn{
R_{jx} = \left\{ n + 1 + \sum_{i=1}^n
\mathrm{sgn} \left( x_j - x_i \right) \right\} / 2}
}
\note{
Current Version is for complete observations only.
 The test statistic is not corrected for ties.
}
\examples{
data(maxau)
s <- maxau[,"s"]; Q <- maxau[,"Q"]
partial.mk.test(s,Q)

}
\references{
Libiseller, C. and Grimvall, A., (2002).
Performance of partial Mann-Kendall tests for trend detection in the
presence of covariates. Environmetrics 13, 71--84,
\doi{10.1002/env.507}.
}
\seealso{
\code{\link{partial.cor.trend.test}},
}
\keyword{nonparametric}
\keyword{ts}
