% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_weight_at_dose.R
\name{total_weight_at_dose}
\alias{total_weight_at_dose}
\alias{total_weight_at_dose.default}
\title{Get the total weight of patient outcomes at the doses under investigation.}
\usage{
total_weight_at_dose(x, dose, ...)

\method{total_weight_at_dose}{default}(x, dose = NULL, ...)
}
\arguments{
\item{x}{An R object of class \code{"dose_finding_fit"}}

\item{dose}{Optional integer, at which dose-level? Omit to get data on all doses.}

\item{...}{arguments passed to other methods}
}
\value{
numerical vector
}
\description{
Get the total weight of patient outcomes at the doses under investigation.
}
\examples{
\dontrun{
# CRM example
fit <- stan_crm(skeleton = c(0.1, 0.2, 0.35, 0.6), target = 0.2,
                model = 'empiric', beta_sd = sqrt(1.34), seed = 123,
                doses = c(1, 1, 2, 2, 2),
                tox   = c(0, 0, 0, 0, 0),
                weights = c(1, 1, 0.9, 0.1, 0.1))

total_weight_at_dose(fit)            # c(2, 1.1, 0, 0)
total_weight_at_dose(fit, dose = 2)  # 1.1
}
}
