% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_alpha2boundary.R
\name{alpha2boundary}
\alias{alpha2boundary}
\title{Convert cumulative alpha levels to normal critical boundaries}
\usage{
alpha2boundary(
  alphas,
  t,
  initIntvl = c(1, 2 * stats::qnorm(p = alphas[1], lower.tail = FALSE))
)
}
\arguments{
\item{alphas}{a list of cumulative errors from some error spending functions}

\item{t}{a vector of information times}

\item{initIntvl}{a pair of numbers as the lower and upper bounds of critical boundaries, used for \code{stats::uniroot} function}
}
\value{
a vector of critical boundaries
}
\description{
This function converts cumulative alpha levels into normal critical boundaries.
}
\details{
The current version of \code{ldbounds::bounds} does not work for Hwang-Shih-DeCani boundaries.
}
\examples{
library(ldbounds)
tvec <- c(0.5,1)
result <- ldbounds::bounds(t=tvec, iuse=1, alpha=0.05)
print(result$upper.bounds)
bd <- alpha2boundary(alphas = result$exit.pr, t=tvec)
print(bd)
}
\author{
Jiangtao Gou
}
