% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triplot.R
\name{calculate_triplot}
\alias{calculate_triplot}
\alias{calculate_triplot.explainer}
\alias{calculate_triplot.default}
\alias{print.triplot}
\alias{model_triplot}
\alias{predict_triplot}
\title{Calculate triplot that sums up automatic aspect/feature importance grouping}
\usage{
calculate_triplot(x, ...)

\method{calculate_triplot}{explainer}(
  x,
  type = c("predict", "model"),
  new_observation = NULL,
  N = 1000,
  loss_function = DALEX::loss_root_mean_square,
  B = 10,
  fi_type = c("raw", "ratio", "difference"),
  clust_method = "complete",
  ...
)

\method{calculate_triplot}{default}(
  x,
  data,
  y = NULL,
  predict_function = predict,
  label = class(x)[1],
  type = c("predict", "model"),
  new_observation = NULL,
  N = 1000,
  loss_function = DALEX::loss_root_mean_square,
  B = 10,
  fi_type = c("raw", "ratio", "difference"),
  clust_method = "complete",
  ...
)

\method{print}{triplot}(x, ...)

model_triplot(x, ...)

predict_triplot(x, ...)
}
\arguments{
\item{x}{an explainer created with the \code{DALEX::explain()} function
or a model to be explained.}

\item{...}{other parameters}

\item{type}{if \code{predict} then aspect_importance is used, if
\code{model} than feature_importance is calculated}

\item{new_observation}{selected observation with columns that corresponds to
variables used in the model, should be without target variable}

\item{N}{number of rows to be sampled from data
NOTE: Small \code{N} may cause unstable results.}

\item{loss_function}{a function that will be used to assess variable
importance, if \code{type = model}}

\item{B}{integer, number of permutation rounds to perform on each variable
in feature importance calculation, if \code{type = model}}

\item{fi_type}{character, type of transformation that should be applied for
dropout loss, if \code{type = model}. "raw" results raw drop losses,
"ratio" returns \code{drop_loss/drop_loss_full_model}.}

\item{clust_method}{the agglomeration method to be used, see
\code{\link[stats]{hclust}} methods}

\item{data}{dataset, it will be extracted from \code{x} if it's an explainer
NOTE: Target variable shouldn't be present in the \code{data}}

\item{y}{true labels for \code{data}, will be extracted from \code{x}
if it's an explainer}

\item{predict_function}{predict function, it will be extracted from \code{x}
if it's an explainer}

\item{label}{name of the model. By default it's extracted from the 'class'
attribute of the model.}
}
\value{
triplot object
}
\description{
This function shows:
\itemize{ \item plot for the importance of single variables,
\item tree that shows importance for every newly expanded group of variables,
\item clustering tree. }
}
\examples{

library(DALEX)
set.seed(123)
apartments_num <- apartments[,unlist(lapply(apartments, is.numeric))]
apartments_num_lm_model <- lm(m2.price ~ ., data = apartments_num)
apartments_num_new_observation <- apartments_num[30, ]
explainer_apartments <- explain(model = apartments_num_lm_model,
                                data = apartments_num[,-1],
                                y = apartments_num[, 1],
                                verbose = FALSE)
apartments_tri <- calculate_triplot(x = explainer_apartments,
                                    new_observation =
                                      apartments_num_new_observation[-1])
apartments_tri
                                   

}
