% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triptych_roc.R
\name{roc}
\alias{roc}
\alias{as_roc}
\title{Evaluation of forecasts using ROC curves}
\usage{
roc(x, y_var = "y", ..., y = NULL, concave = TRUE)

as_roc(x, r)
}
\arguments{
\item{x}{A data frame, list, matrix, or other object that can be coerced to a tibble. Contains numeric forecasts, and observations (optional).}

\item{y_var}{A variable in \code{x} that contains observations. Specified as the argument \code{var}in \code{\link[dplyr:pull]{dplyr::pull()}}.}

\item{...}{Unused.}

\item{y}{A numeric vector of observations. If supplied, overrides \code{y_var}. Otherwise, defaults to \code{dplyr::pull(x, y_var)}.}

\item{concave}{A boolean value indicating whether to calculate the concave hull
or the raw ROC diagnostic.}

\item{r}{A reference triptych_mcbdsc object whose attributes are used for casting.}
}
\value{
A \code{triptych_roc} object, that is a \code{vctrs_vctr} subclass, and has
a length equal to number of forecasting methods supplied in \code{x}. Each entry
is named according to the corresponding forecasting method,
and contains a list of named objects:
\itemize{
\item \code{estimate}: A data frame of hit rates and false rates.
\item \code{region}: Either an empty list, or a data frame of pointwise
confidence intervals (along diagonal lines with slope \eqn{-\pi_0/\pi_1})
added by \code{\link[=add_confidence]{add_confidence()}}.
\item \code{x}: The numeric vector of original forecasts.
}
Access is most convenient through \code{\link[=estimates]{estimates()}}, \code{\link[=regions]{regions()}}, and \code{\link[=forecasts]{forecasts()}}.
}
\description{
A ROC curve visualizes discrimination ability by displaying the hit rate against
the false alarm rate for all threshold values.
}
\examples{
data(ex_binary, package = "triptych")

rc <- roc(ex_binary)
rc

# 1. Choose 4 predictions
# 2. Visualize
# 3. Adjust the title of the legend
rc[c(1, 3, 6, 9)] |>
  autoplot() +
  ggplot2::guides(colour = ggplot2::guide_legend("Forecast"))
  
# Build yourself using accessors
library(ggplot2)
df_est <- estimates(rc[c(1, 3, 6, 9)])
ggplot(df_est, aes(x = FAR, y = HR, col = forecast)) +
  geom_segment(aes(x = 0, y = 0, xend = 1, yend = 1)) +
  geom_path()

}
\seealso{
Accessors: \code{\link[=estimates]{estimates()}}, \code{\link[=regions]{regions()}}, \code{\link[=forecasts]{forecasts()}}, \code{\link[=observations]{observations()}}

Adding uncertainty quantification: \code{\link[=add_confidence]{add_confidence()}}

Visualization: \code{\link[=plot.triptych_roc]{plot.triptych_roc()}}, \code{\link[=autoplot.triptych_roc]{autoplot.triptych_roc()}}
}
