% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrtest}
\alias{lrtest}
\title{Log-Rank Test of Survival Curve Difference}
\usage{
lrtest(
  data,
  rep = "",
  stratum = "",
  treat = "treat",
  time = "time",
  time2 = "",
  event = "event",
  weight = "",
  rho1 = 0,
  rho2 = 0
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{rep}: The replication for by-group processing.
\item \code{stratum}: The stratum.
\item \code{treat}: The treatment.
\item \code{time}: The follow-up time for right censored data, or
the left end of each interval for counting process data.
\item \code{time2}: The right end of each interval for counting process
data. Intervals are assumed to be open on the left
and closed on the right, and event indicates whether an event
occurred at the right end of each interval.
\item \code{event}: The event indicator, 1=event, 0=no event.
\item \code{weight}: The optional subject-level weight.
}}

\item{rep}{The name(s) of the replication variable(s) in the input data.}

\item{stratum}{The name(s) of the stratum variable(s) in the input data.}

\item{treat}{The name of the treatment variable in the input data.}

\item{time}{The name of the time variable or the left end of each
interval for counting process data in the input data.}

\item{time2}{The name of the right end of each interval for counting
process data in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{weight}{The name of the weight variable in the input data.}

\item{rho1}{The first parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{The second parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{uscore}: The numerator of the log-rank test statistic.
\item \code{vscore}: The variance of the log-rank score test statistic.
\item \code{logRankZ}: The Z-statistic value.
\item \code{logRankPValue}: The two-sided p-value.
\item \code{rho1}: The first parameter of the Fleming-Harrington weights.
\item \code{rho2}: The second parameter of the Fleming-Harrington weights.
\item \code{rep}: The replication.
}
}
\description{
Obtains the log-rank test using the Fleming-Harrington
family of weights.
}
\examples{

df <- lrtest(data = rawdata, rep = "iterationNumber",
             stratum = "stratum", treat = "treatmentGroup",
             time = "timeUnderObservation", event = "event",
             rho1 = 0.5, rho2 = 0)
head(df)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
