% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rGARMA.R
\name{rGARMA}
\alias{rGARMA}
\title{Generate random vectors from the stationary GARMA distribution}
\usage{
rGARMA(
  n,
  m,
  condvals = as.numeric(NA),
  mean = 0,
  errorvar = 1,
  ar = numeric(0),
  ma = numeric(0)
)
}
\arguments{
\item{n}{Positive integer giving the number of random vectors to generate}

\item{m}{Positive integer giving the dimension of the random vectors to generate (i.e., the number of values in each time-series)}

\item{condvals}{Either a single value ```NA``` or a numeric vector with ```m``` elements; numeric entries are conditioning values for the generated vector}

\item{mean}{The mean parameter}

\item{errorvar}{The error variance parameter}

\item{ar}{Vector of auto-regressive coefficients (all roots of AR characteristic polynomial must be outside the unit circle)}

\item{ma}{Vector of moving-average coefficients}
}
\description{
This function generates random vectors from the stationary Gaussian auto-regressive moving-average (GARMA) distribution.  The user specifies
the number of vectors ```n``` and their dimension ```m``` and the function returns an n x m matrix of generated time-series from the GARMA
distribution with the specified parameters.  By default the function generates from the marginal GARMA distribution, but the user may give
conditional values in the ```condvals``` vector to generate from the associated conditional distribution (non-conditional values in this
vector are given as ```NA```).
}
\examples{
#Set the model parameters
AR <- c(0.8, -0.2)
MA <- c(0.6,  0.3)
#Generate random time-series from the GARMA distribution
SERIES <- rGARMA(n = 16, m = 30, ar = AR, ma = MA)

#Set the conditional values
CONDVALS     <- rep(NA, 30)
CONDVALS[1]  <- -4
CONDVALS[12] <-  0
CONDVALS[30] <-  4

#Generate and plot random time-series from the GARMA distribution
SERIES.COND <- rGARMA(n = 16, m = 30, ar = AR, ma = MA, condvals = CONDVALS)
}
