\name{TVAR.boot}
\alias{TVAR.boot}
\alias{VAR.boot}

\title{Bootstrap a multivariate Threshold Autoregressive (TVAR) model}

\description{
Recursive bootstrap of a multivariate Threshold VAR (TVAR)
}
\usage{
TVAR.boot(TVARobject, innov, seed, ...)
VAR.boot(VARobject, innov, seed, ...)
}


\value{
A matrix with the bootstraped series.
}

\arguments{
  \item{TVARobject}{Object of class \code{TVAR} generated by function \code{\link{TVAR}}}
  \item{ VARobject}{Object of class \code{ VAR} generated by function \code{\link{lineVar}}}
  \item{innov}{Innovations used for bootstrap. If missing, residuals are resampled. }
\item{seed}{Optional. Seed for the random resampling function.}
  \item{\dots}{Further arguments passed to the underlying (un-exported) \code{TVAR.gen} function}
}

\details{
The function bootstraps a given model. This is done on a object generated by TVECM (or VECM). A simple residual recursive  bootstrap is done.
}

\seealso{
\code{\link{TVAR}} to estimate a TVAR, \code{\link{VAR.sim}} to simulate/bootstrap a VAR, \code{\link{TVECM.sim}} to simulate/bootstrap a TVECM. 
}

\author{Matthieu Stigler}
\examples{


##Bootstrap a TVAR with two threshold (three regimes)
data(zeroyld)
serie<-zeroyld
mod <- TVAR(data=serie,lag=1, nthresh=1)
TVAR.boot(mod)

}
\keyword{ ts }
\keyword{ bootstrap }

