% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{jeffreys}
\alias{approx_joint_jeffreys}
\alias{approx_marginal_jeffreys}
\alias{exact_joint_jeffreys}
\alias{exact_marginal_jeffreys}
\alias{jeffreys}
\title{Compute different types of importance weights based on Jeffreys's prior}
\usage{
approx_joint_jeffreys(psi, xreg = NULL, p, q, n)

approx_marginal_jeffreys(psi, p, q)

exact_joint_jeffreys(psi, xreg = NULL, p, q, n)

exact_marginal_jeffreys(psi, p, q, n)
}
\arguments{
\item{psi}{vector containing the ar and ma parameters (in that order).}

\item{xreg}{matrix or data frame containing the exogenous variables
(not including the intercept which is always included for non-differenced series)}

\item{p}{number of ar parameters}

\item{q}{number of ma parameters}

\item{n}{length of the time series}
}
\description{
These functions compute different types of importance weights based on Jeffreys's priors used in \code{\link{arima_pi}}.
}
\seealso{
\code{\link{arima_pi}}.
}

