% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivarts.r
\name{pacfmat}
\alias{pacfmat}
\title{\code{pacfmat} sequence of partial autocorrelation matrices and related statistics for a multivariate time series}
\usage{
pacfmat(y, lag.max)
}
\arguments{
\item{y}{multivariate time series}

\item{lag.max}{maximum number of lag}
}
\value{
out  list with components: 
 \item{M}{array with matrices of partial autocovariances divided by their standard error}
 \item{M1}{array with indicators if partial autocovariances are significantly greater (+), lower (-) than the   
         critical value or insignificant (.)  }
 \item{R}{array with matrices of partial autocovariances  }
 \item{S}{matrix of diagonals of residual covariances (row-wise) }
 \item{Test}{test statistic  }
 \item{pval}{p value of test}
}
\description{
\code{pacfmat} sequence of partial autocorrelation matrices and related statistics for a multivariate time series
}
\examples{
data(ICECREAM)
out <- pacfmat(ICECREAM,7) 
}
