% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_trend.R
\name{ts_trend}
\alias{ts_trend}
\title{Loess Trend Estimation}
\usage{
ts_trend(x, ...)
}
\arguments{
\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo}, \code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, \code{tis}, \code{irts} or \code{timeSeries}.}

\item{...}{arguments, passed to \code{\link[stats:loess]{stats::loess()}}:
\itemize{
\item \code{degree} degree of Loess smoothing
\item \code{span} smoothing parameter, if \code{NULL}, an automated search performed (see Details)
}}
}
\description{
Trend estimation that uses \code{\link[stats:loess]{stats::loess()}}.
}
\examples{
\donttest{
ts_plot(
   `Raw series` = fdeaths,
   `Loess trend` = ts_trend(fdeaths),
   title = "Deaths from Lung Diseases",
   subtitle = "per month"
)
}
}
