% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_frequency.R
\name{ts_frequency}
\alias{ts_frequency}
\title{Change Frequency}
\usage{
ts_frequency(
  x,
  to = c("year", "quarter", "month", "week", "day", "hour", "min", "sec"),
  aggregate = "mean",
  na.rm = FALSE
)
}
\arguments{
\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo},
\code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, \code{tis}, \code{irts} or
\code{timeSeries}.}

\item{to}{desired frequency, either a character string (\code{"year"},
\code{"quarter"}, \code{"month"}) or an integer (\code{1}, \code{4}, \code{12}).}

\item{aggregate}{character string, or function. Either \code{"mean"}, \code{"sum"},
\code{"first"}, or \code{"last"}, or any aggregate function, such as \code{\link[base:mean]{base::mean()}}.}

\item{na.rm}{logical, if \code{TRUE}, incomplete periods are aggregated as
well. For irregular series, incomplete periods are always aggregated.}
}
\value{
a ts-boxable time series, with the same class as the input.
}
\description{
Changes the frequency of a time series. By default, incomplete
periods of regular series are omitted.
}
\details{
The \href{https://CRAN.R-project.org/package=tempdisagg}{tempdisagg package}
can convert low frequency to high frequency data and
has support for ts-boxable objects. See
\code{vignette("hf-disagg", package = "tempdisagg")}.
}
\examples{
\donttest{
ts_frequency(cbind(mdeaths, fdeaths), "year", "sum")
ts_frequency(cbind(mdeaths, fdeaths), "quarter", "last")

ts_frequency(AirPassengers, 4, "sum")

# Note that incomplete years are omited by default
ts_frequency(EuStockMarkets, "year")
ts_frequency(EuStockMarkets, "year", na.rm = TRUE)
}
}
