% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{slide}
\alias{slide}
\alias{slide.default}
\alias{slide.data.frame}
\alias{slider}
\title{Sliding window calculation}
\usage{
slide(x, .f, ..., size = 1, fill)

\method{slide}{default}(x, .f, ..., size = 1, fill = NA_real_)

\method{slide}{data.frame}(x, .f, ..., size = 1, fill = NA,
  deframe = TRUE)

slider(x, size = 1)
}
\arguments{
\item{x}{A vector of numerics, or data frame.}

\item{.f}{A function or one-sided formula using purrr-like syntax. If a
formula, it is converted to a function.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{size}{An integer for window size.}

\item{fill}{A single value or data frame to replace \code{NA}.}

\item{deframe}{TRUE a list is returned. FALSE returns a data frame.}
}
\description{
\code{slide()} is an S3 method to carry out rolling window calculation; \code{slider()}
splits the input \code{x} to a list according to the window size.
}
\details{
The \code{slide()} function attempts to tackle more general problems using
the purrr-like syntax. For some specialist functions like \code{mean} and \code{sum},
you may like to check out for
\href{https://CRAN.R-project.org/package=RcppRoll}{RcppRoll} for faster performance.
}
\examples{
# sliding through a vector ----
x <- 1:10
slide(x, mean, size = 3)
slide(x, ~ mean(.), size = 3)
slide(x, mean, size = 3, fill = 0)

# slider ----
slider(x, size = 3)

\dontrun{
# takes a little longer for cran check
# sliding a 2-day window for a data frame ----
sx <- pedestrian \%>\% 
  filter(Sensor == "Southern Cross Station", Date <= as.Date("2015-01-31"))
# directly return a data frame of fitted values and residuals
diag_sx <- sx \%>\%
  slide(function(x) {
    fit <- lm(Count ~ Time, data = x)
    data.frame(fitted = fitted(fit), resid = residuals(fit))
  }, size = 48, deframe = FALSE)
diag_sx[48:57, ]
# save lm models as additional columns
lm_sx <- sx \%>\% 
  mutate(lm = slide(., ~ lm(Count ~ Time, data = .), size = 48))
lm_sx[48:57, ]
}
}
\seealso{
\link{tile} for tiling window without overlapping observations;
\link{stretch} for expanding more observations
}
