% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsummarise.R
\name{tsummarise}
\alias{tsummarise}
\alias{tsummarize}
\title{Aggregate over calendar periods}
\usage{
tsummarise(.data, ...)

tsummarize(.data, ...)
}
\arguments{
\item{.data}{A data frame (of \code{tbl_ts} class).}

\item{...}{Name-value pairs of expressions. The index variable must be present
in the calls, coupled with an index function, to carry out the calculation.
The index functions that can be used, but not limited:
\itemize{
\item \link[lubridate:year]{lubridate::year}: yearly aggregation
\item \link{yearquarter}: quarterly aggregation
\item \link{yearmonth}: monthly aggregation
\item \link{as.Date} or \link[lubridate:as_date]{lubridate::as_date}: daily aggregation
\item \link[lubridate:ceiling_date]{lubridate::ceiling_date} or \link[lubridate:round_date]{lubridate::round_date}: sub-daily aggregation
\item other index functions from other packages
}}
}
\description{
It computes summary statistics for a tsibble over calendar periods, usually
used in combination of \link{group_by}.
}
\details{
One grouping level will be dropped.
}
\examples{
# Monthly counts across Sensors
data(pedestrian)
monthly_ped <- pedestrian \%>\% 
  group_by(Sensor) \%>\% 
  tsummarise(
    Year_Month = yearmonth(Date_Time), # Year_Month will be the new index
    Max_Count = max(Count),
    Min_Count = min(Count)
  )
monthly_ped
index(monthly_ped)

# Annual trips by Region and State ----
data(tourism)
tourism \%>\% 
  group_by(Region | State) \%>\% 
  tsummarise(Year = lubridate::year(Quarter), Total = sum(Trips))
}
