% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{nyc_bikes}
\alias{nyc_bikes}
\title{NYC Citi Bike trips}
\format{
Time series of class \code{tsibble}
}
\source{
Citi Bike NYC, \url{https://www.citibikenyc.com/system-data}
}
\description{
A sample from NYC Citi Bike usage of 10 bikes throughout 2018. The data
includes event data on each trip, including the trip's start and end times
and locations. The customer's gender, birth year and bike usage type is
also available.
}
\details{
\code{nyc_bikes} is a \code{tsibble} containing event data, the events include
these details:
\tabular{ll}{
start_time:   \tab The time and date when the trip was started.\cr
stop_time:    \tab The time and date when the trip was ended.\cr
start_station:\tab A unique identifier for the starting bike station.\cr
start_lat:    \tab The latitude of the starting bike station.\cr
start_long:   \tab The longitude of the starting bike station.\cr
end_station:  \tab A unique identifier for the destination bike station.\cr
end_lat:      \tab The latitutde of the destination bike station.\cr
end_long:     \tab The longitude of the destination bike station.\cr
type:         \tab The type of trip. A "Customer" has purchased either a 24-hour or 3-day pass, and a "Subscriber" has purchased an annual subscription.\cr
birth_year    \tab The bike rider's year of birth.\cr
gender:       \tab The gender of the bike rider.\cr
}

Each series is uniquely identified by one key:
\tabular{ll}{
bike_id:      \tab A unique identifier for the bike.\cr
}
}
\examples{
library(tsibble)
nyc_bikes
}
\keyword{datasets}
