% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-motifs.R
\name{find_motif}
\alias{find_motif}
\alias{find_motif.MatrixProfile}
\alias{find_motif.MultiMatrixProfile}
\title{Search for Motifs}
\usage{
find_motif(.mp, ...)

\method{find_motif}{MatrixProfile}(.mp, data, n_motifs = 3,
  n_neighbors = 10, radius = 3, exclusion_zone = NULL, ...)

\method{find_motif}{MultiMatrixProfile}(.mp, data, n_motifs = 3,
  mode = c("guided", "unconstrained"), n_bit = 4,
  exclusion_zone = NULL, n_dim = NULL, ...)
}
\arguments{
\item{.mp}{a TSMP object of class \code{MatrixProfile} or \code{MultiMatrixProfile}.}

\item{...}{further arguments to be passed to class specific function.}

\item{data}{the data used to build the Matrix Profile, if not embedded.}

\item{n_motifs}{an \code{int}. Number of motifs to find. (Default is \code{3}).}

\item{n_neighbors}{an \code{int}. Number of neighbors to find. (Default is \code{10}).}

\item{radius}{an \code{int}. Set a threshold to exclude matching neighbors with distance > current
motif distance * \code{radius}. (Default is \code{3}).}

\item{exclusion_zone}{if a \code{number} will be used instead of embedded value. (Default is \code{NULL}).}

\item{mode}{a \code{string}. Guided or Unconstrained search. Allow partial match. (Default is \code{guided}).}

\item{n_bit}{an \code{ìnt}. Bit size for discretization. Ignored on Guided search. (Default is \code{4}).}

\item{n_dim}{an \code{int}. Number of dimensions to use on Guided search instead of embedded value. (Default is \code{NULL}).}
}
\value{
For class \code{MatrixProfile}, returns the input \code{.mp} object with a new name \code{motif}. It contains: \code{motif_idx}, a \code{list}
of motif pairs founded and \code{motif_neighbor} a \code{list} with respective motif's neighbors.

For class \code{MultiMatrixProfile}, returns the input \code{.mp} object with a new name \code{motif}. It contains: \code{motif_idx}, a \code{vector}
of motifs founded and \code{motif_dim} a \code{list} the dimensions where the motifs were founded.
}
\description{
Search for Motifs
}
\examples{
# Single dimension data
w <- 50
data <- mp_gait_data
mp <- tsmp(data, window_size = w, exclusion_zone = 1 / 4, verbose = 0)
mp <- find_motif(mp)

# Multidimension data
w <- mp_toy_data$sub_len
data <- mp_toy_data$data[1:200, ]
mp <- tsmp(data, window_size = w, mode = "mstomp", verbose = 0)
mp <- find_motif(mp)
}
