% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_lowess.R
\name{ts_fil_lowess}
\alias{ts_fil_lowess}
\title{Lowess Smoothing}
\usage{
ts_fil_lowess(f = 0.2)
}
\arguments{
\item{f}{smoothing parameter. The larger this value, the smoother the series will be.
This provides the proportion of points on the plot that influence the smoothing.}
}
\value{
a \code{ts_fil_lowess} object.
}
\description{
It is a smoothing method that preserves the primary trend of the original observations and is used to remove noise and spikes in a way that allows data reconstruction and smoothing.
}
\examples{
# time series with noise
library(daltoolbox)
data(sin_data)
sin_data$y[9] <- 2*sin_data$y[9]

# filter
filter <- ts_fil_lowess(f = 0.2)
filter <- fit(filter, sin_data$y)
y <- transform(filter, sin_data$y)

# plot
plot_ts_pred(y=sin_data$y, yadj=y)
}
