% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle_outliers.R
\name{handle_outliers}
\alias{handle_outliers}
\title{Detect and model unreliable outliers of time series data}
\usage{
handle_outliers(
  data,
  tau = 0.5,
  S,
  no.of.last.indices.to.fix = S,
  indices.to.fix = NULL,
  outlier.lower.cap = 2 * log(dim(as.matrix(data))[1]),
  outlier.upper.cap = log(dim(as.matrix(data))[1]),
  margin = outlier.upper.cap,
  max.periods.to.smooth = 48,
  extreg = NULL,
  use.data.as.ext = FALSE,
  min.val = -Inf,
  max.val = Inf,
  ...
)
}
\arguments{
\item{data}{an input vector, matrix or data frame of dimension nobs x nvars
possibly containing unreliable outliers; each column is a variable.}

\item{tau}{the quantile(s) of the replaced values to be estimated in the
quantile regression. Tau accepts all values in (0,1), the default is 0.5.}

\item{S}{a number of observations per period, e.g. per day.}

\item{no.of.last.indices.to.fix}{a number of observations in the tail of
the data to be fixed, by default set to S.}

\item{indices.to.fix}{indices of the data to be fixed. If NULL, then it is
calculated based on the no.of.last.indices.to.fix parameter. Otherwise, the
no.of.last.indices.to.fix parameter is ignored.}

\item{outlier.lower.cap}{a number of observations that should fall above
(below) the outlier lower cap, used for the calculation of the interquantile
range. By default set to 2log(nobs).}

\item{outlier.upper.cap}{a number of observations that should fall above
(below) the outlier upper cap, used for the calculation of the interquantile
range. By default set to log(nobs).}

\item{margin}{a value that indicates the number of interquantile ranges
above (below) the quantile upper cap that is still considered not to be an
outlier. By default equals outlier.upper.cap.}

\item{max.periods.to.smooth}{maximum number of S periods to be smoothed in
the detection of outliers in the differential series. By default set to 48.}

\item{extreg}{a vector, matrix or data frame of data containing external
regressors.}

\item{use.data.as.ext}{logical specifying whether to use the remaining
variables in the data as external regressors or not.}

\item{min.val}{a single value or a vector of length nvars providing the
minimum possible value of each variable in the data. If a single value, then
it applies to all variables. By default set to -Inf.}

\item{max.val}{a single value or a vector of length nvars providing the
maximum possible value of each variable in the data. If a single value, then
it applies to all variables. By default set to Inf.}

\item{...}{additional arguments for the \link[tsrobprep]{model_missing_data}
function.}
}
\value{
An object of class "tsrobprep" which contains the original data, the
indices of the data that were modelled, the given quantile values, a list of
sparse matrices with the modelled data to be imputed and a list of the numbers
of models estimated for every variable.
}
\description{
Returns an object of class "tsrobprep" which contains the original data and
the modelled values to be imputed. The function handle_outliers detects
unreliable outliers given specific threshold and suggests replacement using
\link[tsrobprep]{model_missing_data} function. The function analyses both
absolute level of the data and the differential series. The function is
designed for numerical data only.
}
\details{
The function recognizes two types of outliers: on the absolute level
and in the differential series. As outliers are considered all observations
that in any of the above mentioned series fall above (below)

interquantile_range * margin

where margin is given by the user and

interquantile_range = upper_quantile - lower_quantile.

The upper and lower quantiles are derived from the data based on the
outlier.upper.cap and outlier.lower.cap arguments, respectively. In the case
of outliers in the differential series, the function uses also smoothing, i.e. if
after replacing of the outliers in the differential series, the series still
exhibits outliers, the neighbouring observations are also replaced in order
to smooth the "jump". The outlier values are replaced using the
\link[tsrobprep]{model_missing_data} function.

The modelled values can be imputed using \link[tsrobprep]{impute_modelled_data}
function.
}
\examples{
outliers.handled <- handle_outliers(data = GBload[,-1], S = 48, tau = 0.5,
                    no.of.last.indices.to.fix = dim(GBload)[1], min.val = 0)
outliers.handled$estimated.models
outliers.handled$replaced.indices
new.GBload <- impute_modelled_data(outliers.handled)
}
\seealso{
\link[tsrobprep]{model_missing_data}, \link[tsrobprep]{impute_modelled_data},
\link[tsrobprep]{auto_data_cleaning}
}
