% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_channel_activities.R
\name{list_channel_activities}
\alias{list_channel_activities}
\title{List Channel Activity}
\usage{
list_channel_activities(filter = NULL, part = "snippet", max_results = 50,
  page_token = NULL, published_after = NULL, published_before = NULL,
  region_code = NULL, simplify = TRUE, ...)
}
\arguments{
\item{filter}{string; Required.
named vector of length 1
potential names of the entry in the vector: 
\code{channel_id}: ID of the channel. Required. No default.}

\item{part}{specify which part do you want. It can only be one of the three: \code{contentDetails, id, snippet}. Default is \code{snippet}.}

\item{max_results}{Maximum number of items that should be returned. Integer. Optional. Can be between 0 and 50. Default is 50.}

\item{page_token}{specific page in the result set that should be returned, optional}

\item{published_after}{Character. Optional. RFC 339 Format. For instance, "1970-01-01T00:00:00Z"}

\item{published_before}{Character. Optional. RFC 339 Format. For instance, "1970-01-01T00:00:00Z"}

\item{region_code}{ISO 3166-1 alpha-2 country code, optional, see also \code{\link{list_regions}}}

\item{simplify}{Data Type: Boolean. Default is \code{TRUE}. If \code{TRUE} and if part requested is \code{contentDetails}, 
the function returns a \code{data.frame}. Else a list with all the information returned.}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
named list
If \code{simplify} is \code{TRUE}, a data.frame is returned with 18 columns:
\code{publishedAt, channelId, title, description, thumbnails.default.url, thumbnails.default.width, thumbnails.default.height,
thumbnails.medium.url, thumbnails.medium.width, thumbnails.medium.height, thumbnails.high.url, thumbnails.high.width, 
thumbnails.high.height, thumbnails.standard.url, thumbnails.standard.width, thumbnails.standard.height, channelTitle, type}
}
\description{
Returns a list of channel events that match the request criteria.
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

list_channel_activities(filter = c(channel_id = "UCRw8bIz2wMLmfgAgWm903cA"))
list_channel_activities(filter = c(channel_id = "UCRw8bIz2wMLmfgAgWm903cA", regionCode="US"))
list_channel_activities(filter = c(channel_id = "UCMtFAi84ehTSYSE9XoHefig"),  
                        published_before = "2016-02-10T00:00:00Z", 
                        published_after = "2016-01-01T00:00:00Z")
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/activities/list}
}
