\name{WspecMat-class}
\docType{class}
\alias{WspecMat-class}
\alias{[,WspecMat-method}
\alias{coerce,Wspec,WspecMat-method}
\alias{[,WspecMat-method}
\alias{WspecMat}
\title{Class WspecMat}
\description{Class \dQuote{WspecMat} (\emph{W}ave \emph{spec}trums as \emph{Mat}rix).
    Objects of this class represent a bunch of periodograms 
    (see \code{\link{periodogram}}, each generated by \code{\link{spectrum}})
    corresponding to one or several windows of one \code{\link{Wave}} object.
    Redundancy (e.g. same frequencies in each of the periodograms) will be omitted, 
    hence reducing memory consumption.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("WspecMat", ...)},
but regularly they will be created from a \code{\link{Wspec}} object 
by calls such as \code{as(Wspec_Object, "WspecMat")}.
}
\section{Slots}{
    The following slots are defined. For details see the constructor function \code{\link{periodogram}}.
  \describe{
    \item{\code{freq}:}{Object of class \code{"numeric"}}
    \item{\code{spec}:}{Object of class \code{"matrix"}}
    \item{\code{kernel}:}{Object of class \code{"ANY"}}
    \item{\code{df}:}{Object of class \code{"numeric"}}
    \item{\code{taper}:}{Object of class \code{"numeric"}}
    \item{\code{width}:}{Object of class \code{"numeric"}}
    \item{\code{overlap}:}{Object of class \code{"numeric"}}
    \item{\code{normalize}:}{Object of class \code{"logical"}}
    \item{\code{starts}:}{Object of class \code{"numeric"}}
    \item{\code{stereo}:}{Object of class \code{"logical"}}
    \item{\code{samp.rate}:}{Object of class \code{"numeric"}}
    \item{\code{variance}:}{Object of class \code{"numeric"}}
    \item{\code{energy}:}{Object of class \code{"numeric"}}
  }
}
\details{
The subset function \dQuote{\code{[}} extracts the selected 
elements of slots \code{spec}, \code{starts}, \code{variance} and \code{energy}
and returns the other slots unchanged.
}
\author{Uwe Ligges, \email{ligges@statistik.uni-dortmund.de}}
\seealso{the \code{show}, \code{plot} and \code{summary} methods}
\keyword{classes}
\concept{periodogram}
\concept{spectrum}
\concept{music}
\concept{speech}
\concept{Wave}
