% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/documentation.R,
%   R/two_samples.R
\name{kuiper_stat}
\alias{kuiper_stat}
\alias{kuiper_test}
\title{Kuiper Test}
\usage{
kuiper_stat(a, b, power = 1)

kuiper_test(a, b, nboots = 2000, p = default.p)
}
\arguments{
\item{a}{a vector of numbers}

\item{b}{a vector of numbers}

\item{power}{power to raise test stat to}

\item{nboots}{Number of bootstrap iterations}

\item{p}{power to raise test stat to}
}
\value{
Output is a length 2 Vector with test stat and p-value in that order. That vector has 3 attributes -- the sample sizes of each sample, and the number of bootstraps performed for the pvalue.
}
\description{
Performs a permutation based two sample test using the Kuiper test statistic (kuiper_stat).
}
\details{
The Kuiper test compares two ECDFs by looking at the maximum positive and negative difference between them. Formally -- if E is the ECDF of sample 1 and F is the ECDF of sample 2, then KUIPER = max_x E(x)-F(x) + max_x F(x)-E(x). The test p-value is calculated by randomly resampling two samples of the same size using the combined sample.
}
\section{Functions}{
\itemize{
\item \code{kuiper_stat}: Kuiper Test statistic

\item \code{kuiper_test}: Permutation based two sample Kuiper test
}}

\examples{
vec1 = rnorm(20)
vec2 = rnorm(20,4)
kuiper_test(vec1,vec2)
}
