% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R, R/permutation_builder.R
\name{permutation_test_builder}
\alias{permutation_test_builder}
\title{Permutation Test Builder}
\usage{
permutation_test_builder(test_stat_function, default.p = 2)
}
\arguments{
\item{test_stat_function}{a function of two vectors producing a positive number, intended as the test-statistic to be used.}

\item{default.p}{This allows for some introduction of defaults and parameters. Typically used to control the power functions raise something to.}
}
\value{
This function returns a function which will perform permutation tests on given test stat.
}
\description{
This function takes a simple two-sample test statistic and produces a function which performs randomization tests (sampling with replacement) using that test stat.
}
\details{
test_stat_function must be structured to take two separate vectors, and then a third value. i.e. (fun = function(vec1,vec2,val1) ...). See examples.
}
\section{Functions}{
\itemize{
\item \code{permutation_test_builder}: Takes a test statistic, returns a testing function.
}}

\examples{
mean_stat = function(a,b,p) abs(mean(a)-mean(b))**p
myfun = permutation_test_builder(mean_stat,2.0)
vec1 = rnorm(20)
vec2 = rnorm(20,4)
myfun(vec1,vec2)
}
\seealso{
\code{\link[=two_sample]{two_sample()}}
}
