% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eifs.R
\name{ipcw_eif_update}
\alias{ipcw_eif_update}
\title{Iterative IPCW Update Procedure of Efficient Influence Function}
\usage{
ipcw_eif_update(
  data_in,
  C,
  V,
  ipc_mech,
  ipc_weights,
  ipc_weights_norm,
  Qn_estim,
  Hn_estim,
  estimator = c("tmle", "onestep"),
  fluctuation = NULL,
  flucmod_tol = 100,
  eif_reg_type = c("hal", "glm")
)
}
\arguments{
\item{data_in}{A \code{data.table} containing variables and observations of
full data. That is, this corresponds to the data after application of a
censoring process.}

\item{C}{A \code{numeric} binary vector giving the censoring status of a
given observation.}

\item{V}{A \code{data.table} giving the values across all observations of
all variables that play a role in the censoring mechanism.}

\item{ipc_mech}{A \code{numeric} vector containing values that describe the
censoring mechanism for all of the observations. Note that such values are
estimated by regressing the censoring covariates \code{V} on the observed
censoring \code{C} and thus correspond to predicted probabilities of being
censored for each observation.}

\item{ipc_weights}{A \code{numeric} vector of inverse probability of
censoring weights. These are equivalent to \code{C / ipc_mech} in any
initial run of this function. Updated values of this vector are provided as
part of the output of this function, which may be used in subsequent calls
that allow convergence to a more efficient estimate.}

\item{ipc_weights_norm}{A \code{numeric} vector of the weights described in
the previous argument. In this case, the weights are normalized.}

\item{Qn_estim}{A \code{data.table} corresponding to the outcome regression.
This is produced by invoking the internal function \code{est_Q}.}

\item{Hn_estim}{A \code{data.table} corresponding to values produced in the
computation of the auxiliary ("clever") covariate. This is produced easily
by invoking the internal function \code{est_Hn}.}

\item{estimator}{The type of estimator to be fit, either \code{"tmle"} for
targeted maximum likelihood estimation or \code{"onestep"} for a one-step
estimator.}

\item{fluctuation}{A \code{character} giving the type of regression to be
used in traversing the fluctuation submodel. The choices are "weighted" and
"standard".}

\item{flucmod_tol}{A \code{numeric} indicating the largest value to be
tolerated in the fluctuation model for the targeted minimum loss estimator.}

\item{eif_reg_type}{Whether a flexible nonparametric function ought to be
used in the dimension-reduced nuisance regression of the targeting step for
the censored data case. By default, the method used is a nonparametric
regression based on the Highly Adaptive Lasso (from \pkg{hal9001}). Set
this to \code{"glm"} to instead use a simple linear regression model. In
this step, the efficient influence function (EIF) is regressed against
covariates contributing to the censoring mechanism (i.e., EIF ~ V | C = 1).}
}
\value{
A \code{list} containing the estimated outcome mechanism, the fitted
 fluctuation model for TML updates, the updated inverse probability of
 censoring weights (IPCW), normalized versions of the same weights, the
 updated estimate of the efficient influence function, and the estimated
 IPCW component of the EIF.
}
\description{
Iterative IPCW Update Procedure of Efficient Influence Function
}
\details{
An adaptation of the IPCW-TMLE for iteratively constructing an
 efficient inverse probability of censoring weighted TML or one-step
 estimator. The efficient influence function of the parameter and updating
 the IPC weights in an iterative process, until a convergence criteria is
 satisfied.
}
