% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMARconstructor.R
\name{alt_gsmar}
\alias{alt_gsmar}
\title{Construct a GSMAR model based on results from an arbitrary estimation round of \code{fitGSMAR}}
\usage{
alt_gsmar(
  gsmar,
  which_round = 1,
  which_largest,
  calc_qresiduals = TRUE,
  calc_cond_moments = TRUE,
  calc_std_errors = TRUE,
  custom_h = NULL
)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{which_round}{based on which estimation round should the model be constructed? An integer value in 1,...,\code{ncalls}.}

\item{which_largest}{based on estimation round with which largest log-likelihood should the model be constructed?
An integer value in 1,...,\code{ncalls}. For example, \code{which_largest=2} would take the second largest log-likelihood
and construct the model based on the corresponding estimates. If specified, then \code{which_round} is ignored.}

\item{calc_qresiduals}{should quantile residuals be calculated? Default is \code{TRUE} iff the model contains data.}

\item{calc_cond_moments}{should conditional means and variances be calculated? Default is \code{TRUE} iff the model contains data.}

\item{calc_std_errors}{should approximate standard errors be calculated?}

\item{custom_h}{A numeric vector with same the length as the parameter vector: i:th element of custom_h is the difference
used in central difference approximation for partial differentials of the log-likelihood function for the i:th parameter.
If \code{NULL} (default), then the difference used for differentiating overly large degrees of freedom parameters
is adjusted to avoid numerical problems, and the difference is \code{6e-6} for the other parameters.}
}
\value{
Returns an object of class \code{'gsmar'} defining the specified GMAR, StMAR, or G-StMAR model. If data is supplied,
 the returned object contains (by default) empirical mixing weights, some conditional and unconditional moments, and quantile
 residuals. Note that the first p observations are taken as the initial values so the mixing weights, conditional moments, and
 quantile residuals start from the p+1:th observation (interpreted as t=1).
}
\description{
\code{alt_gsmar} constructs a GSMAR model based on results from an arbitrary estimation round of \code{fitGSMAR}.
}
\details{
It's sometimes useful to examine other estimates than the one with the highest log-likelihood value. This function
  is just a simple wrapper to \code{GSMAR} that picks the correct estimates from an object returned by \code{fitGSMAR}.
}
\examples{
\donttest{
 # These are long running examples that take approximately ...
 fit42t <- fitGSMAR(data=M10Y1Y, p=4, M=2, model="StMAR", ncalls=2,
                    seeds=c(1, 6))
 fit42t # Bad estimate in the boundary of the stationarity region!

 # So we build a model based on the next-best local maximum point:
 fit42t_alt <- alt_gsmar(fit42t, which_largest=2)
 fit42t_alt # Overly large degrees of freedom paramter estimate

 # Switch to the appropriate G-StMAR model:
 fit42gs <- stmar_to_gstmar(fit42t_alt)
 fit42gs
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. forthcoming. A mixture autoregressive model based on Student's t-distribution.
           \emph{Communications in Statistics - Theory and Methods}, doi: 10.1080/03610926.2021.1916531
   \item Virolainen S. 2020. A mixture autoregressive model based on Gaussian and Student's t-distributions. arXiv:2003.05221 [econ.EM].
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{iterate_more}}, \code{\link{get_gradient}},
 \code{\link{get_regime_means}}, \code{\link{swap_parametrization}}, \code{\link{stmar_to_gstmar}}
}
