% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_lastools.R
\name{lastool}
\alias{lastool}
\title{simple wrapper for some LAStools functions}
\usage{
lastool(tool = "lasinfo", lasFile = NULL, thinGrid = "1.0",
  keepClass = "2", bulge = "1.5", stepSize = "city",
  subSize = "ultra_fine", gridSize = "1.0",
  proj4 = "+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs",
  rscale = "0.01 0.01 0.01", stepoverlap = NULL, cores = "2",
  xoff = 0, yoff = 0, outpath = NULL, pathLastools = NULL,
  verbose = FALSE, cutExtent = NULL, cutSlice = NULL)
}
\arguments{
\item{tool}{default is \code{lasinfo}   additionally you may choose lasrepair, lasthin,  lasmerge, lasground_new, las2dem, las2txt, lasoverage, lasclip}

\item{lasFile}{default is \code{NULL} path  to the laz/las file(s)}

\item{thinGrid}{default 0.5 meter. Grid stepsize for data thinning}

\item{keepClass}{default is 2. Default ground class of las/laz conform data}

\item{bulge}{default is 1.5. 'A parameter to filter spikes it is set to a stepSize/10 and then clamped into the range from 1.0 to 2.0}

\item{stepSize}{default is 25 meter. lastools key words if \code{city},\code{town},\code{metro},\code{nature},\code{wilderness} or experiment with free values}

\item{subSize}{= "8", default is 8 meter. lastools key words if \code{extra_coarse},\code{coarse},\code{fine},\code{extra_fine},\code{ultra_fine},\code{hyper_fine} or experiment with free values}

\item{gridSize}{resolution of the DTM raster}

\item{proj4}{default is EPSG 32632, any valid proj4 string that is assumingly the correct one}

\item{rscale}{rscale}

\item{stepoverlap}{Spacing of overlap steps aused in lasoverage, default is NULL}

\item{cores}{number of cores that will be used}

\item{xoff}{xoff}

\item{yoff}{yoff}

\item{outpath}{outpath}

\item{pathLastools}{character. folder containing the Windows binary files of the lastools}

\item{verbose}{keep it quiet}

\item{cutExtent}{NULL}

\item{cutSlice}{NULL}
}
\description{
simple wrapper for some lastools functions
}
\examples{
\dontrun{

require(uavRst)
require(link2GI)
# get a laz file from Mr. Isenburg
utils::download.file(url="http://www.cs.unc.edu/~isenburg/lastools/download/test/s1885565.laz",
                           destfile="test.laz",  quiet = TRUE, mode = "wb")
# convert from laz to las
lastool(tool="las2las","test.laz")

}
}
\author{
Chris Reudenbach
}
