% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_rinlidar.R
\name{r_in_lidar}
\alias{r_in_lidar}
\title{wraps the r.in.lidar tool}
\usage{
r_in_lidar(input = NULL, output = NULL, file = NULL, method = NULL,
  type = NULL, base_raster = NULL, zrange = NULL, zscale = NULL,
  intensity_range = NULL, intensity_scale = NULL, percent = NULL,
  pth = NULL, trim = NULL, resolution = NULL, return_filter = NULL,
  class_filter = NULL, flags = c("e", "n", "overwrite", "o"))
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{file}{file}

\item{method}{method}

\item{type}{type}

\item{base_raster}{base_raster}

\item{zrange}{zrange}

\item{zscale}{zscale}

\item{intensity_range}{intensity_range}

\item{intensity_scale}{intensity_scale}

\item{percent}{percent}

\item{pth}{pth}

\item{trim}{trim}

\item{resolution}{resolution}

\item{return_filter}{return_filter}

\item{class_filter}{class filter}

\item{flags}{flags}

\item{r.in.lidar}{[-penosgijdv]}
}
\description{
simple wrapper for 'r.in.lidar' to calculate LiDAR derived raster grids. It creates a \code{raster*} object.
}
\examples{
\dontrun{
require(uavRst)
##- Straightforward example to generate a DTM 
    based on the class 2 minimum returns of a LiDAR file
    
# get a las file from the Spain authorithy (29.2 MB)
# Source: (https://b5m.gipuzkoa.eus/url5000/es/G_22485/PUBLI&consulta=HAZLIDAR)
utils::download.file(url="https://b5m.gipuzkoa.eus/lidar/MT13_08_au_las.zip",
                           destfile="MT13_08_au_las.zip", mode = "wb")
unzip("MT13_08_au_las.zip",junkpaths = TRUE,overwrite = TRUE)

##- extract extent for setting up GRASS region
ext<-lastool(lasFile =  "MT13_08_au.las")
## according to the meta data 
#  source: https://b5m.gipuzkoa.eus/web5000/en/csw/MT13_08_au_en 
#  the projection is EPSG25830. NOTE it is obligate to at the zero transformation params
proj4 = "+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"

##- set up GRASS
result<-link2GI::linkGRASS7(spatial_params = c(ext[2],ext[1],ext[4],ext[3],proj4),
                             resolution = 5.0)
                             
##- use the r.in.lidar tool to generate a pseudo surface model
r_in_lidar(input = "MT13_08_au.las",
           output = "dem",
           method = "min",
           resolution = 5,
           class_filter = 2)
           
##- visualize it
raster::plot(raster::raster(rgrass7::readRAST("dem")))
                            
}
}
\seealso{
\href{https://grass.osgeo.org/grass70/manuals/r.in.lidar.html}{r.in.lidar help}
}
\author{
Chris Reudenbach
}
