% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_classify.R
\name{calc_ext}
\alias{calc_ext}
\title{Convenient function to preprocess synthetic raster bands from a given RGB image and/or DTM/DSM data.}
\usage{
calc_ext(
  calculateBands = FALSE,
  extractTrain = TRUE,
  prefixRun = "temp",
  patterndemFiles = "dem",
  prefixTrainImg = "",
  prefixTrainGeom = "",
  suffixTrainImg = "",
  suffixTrainGeom = "",
  patternIdx = "index",
  patternImgFiles = "",
  channels = c("red", "green", "blue"),
  hara = TRUE,
  haraType = c("simple", "advanced", "higher"),
  stat = TRUE,
  edge = TRUE,
  edgeType = c("gradient", "sobel", "touzi"),
  morpho = TRUE,
  morphoType = c("dilate", "erode", "opening", "closing"),
  rgbi = TRUE,
  indices = c("VVI", "VARI", "NDTI", "RI", "SCI", "BI", "SI", "HI", "TGI", "GLI",
    "NGRDI", "GRVI", "GLAI", "HUE", "CI", "SAT", "SHP"),
  rgbTrans = TRUE,
  colorSpaces = c("CIELab", "CMY", "Gray", "HCL", "HSB", "HSI", "Log", "XYZ", "YUV"),
  pardem = TRUE,
  demType = c("hillshade", "slope", "aspect", "TRI", "TPI", "Roughness", "SLOPE",
    "ASPECT", "C_GENE", "C_PROF", "C_PLAN", "C_TANG", "C_LONG", "C_CROS", "C_MINI",
    "C_MAXI", "C_TOTA", "C_ROTO", "MTPI"),
  morphoMethod = 6,
  minScale = 1,
  maxScale = 8,
  numScale = 2,
  kernel = 3,
  currentDataFolder = NULL,
  currentIdxFolder = NULL,
  cleanRunDir = TRUE,
  sagaLinks = NULL,
  gdalLinks = NULL,
  otbLinks = NULL
)
}
\arguments{
\item{calculateBands}{logical. switch for set on calculation of syntheic bands and indices default = TRUE}

\item{extractTrain}{logical. switch for set on extract training data according to training geometries default = TRUE}

\item{prefixRun}{character. general prefix of all result files of the current run default = "tmp"}

\item{patterndemFiles}{character. mandantory if DEM data is processes. prefix of current DEM default = "dem"}

\item{prefixTrainImg}{character. potential string of characters that is used in the beginning of a shape file prefixTrainImg_SHAPEFILENAME_suffixTrainImg}

\item{prefixTrainGeom}{character. potential string of characters that is used in the beginning of a shape file prefixTrainGeom_SHAPEFILENAME_suffixTrainGeom}

\item{suffixTrainImg}{character. potential string of characters that is used in the beginning of a shape file prefixTrainImg_SHAPEFILENAME_suffixTrainImg}

\item{suffixTrainGeom}{character. potential string of characters that is used in the beginning of a shape file prefixTrainGeom_SHAPEFILENAME_suffixTrainGeom}

\item{patternIdx}{character. code string that will concatenated to the filename to identify the index file}

\item{patternImgFiles}{character. mandantory string that exist in ech imagefile to be processes}

\item{channels}{character. channels to be choosed options are c("red", "green", "blue")  default =  c("red", "green", "blue")}

\item{hara}{logical. switch for using  HaralickTextureExtraction, default = TRUE. \cr}

\item{haraType}{character. hara options, default is c("simple"), other  options are "advanced"  "higher" "all". NOTE:  "higher" takes a LOT of time}

\item{stat}{logical. switch for using statistic default = TRUE the stas are mean,variance, curtosis, skewness}

\item{edge}{logical. switch for using edge filtering default = TRUE}

\item{edgeType}{character. edge options, default is c("gradient","sobel","touzi") all options are c("gradient","sobel","touzi")}

\item{morpho}{logical. switch for using morphological filtering default = TRUE}

\item{morphoType}{character. morphological options, default is c("dilate","erode","opening","closing") all options are ("dilate","erode","opening","closing")}

\item{rgbi}{logical. switch for using rgbi index calcualtions default = TRUE}

\item{indices}{character. RGB indices, default is c("VARI","NDTI","RI","CI","BI","SI","HI","TGI","GLI","NGRDI") all options are c("VVI","VARI","NDTI","RI","SCI","BI","SI","HI","TGI","GLI","NGRDI","GRVI","GLAI","HUE","CI","SAT","SHP")}

\item{rgbTrans}{logical. switch for using color space transforming default = TRUE}

\item{colorSpaces}{character.  RGB colorspace transforming to default c("CIELab","CMY","Gray","HCL","HSB","HSI","Log","XYZ","YUV")}

\item{pardem}{logical. switch for calculating dem parameter, default = FALSE}

\item{demType}{character. ("hillshade","slope", "aspect","TRI","TPI","Roughness")}

\item{morphoMethod}{numeric. saga morphometric method}

\item{minScale}{numeric. in scale for multi scale TPI}

\item{maxScale}{numeric. max scale for multi scale TPI}

\item{numScale}{numeric. number of scale for multi scale TPI}

\item{kernel}{numeric. size of kernel for filtering and statistics, default is  3}

\item{currentDataFolder}{NULL folder to image (and shape) data}

\item{currentIdxFolder}{NULL folder for saving the results}

\item{cleanRunDir}{logical. TRUE logical switch for deleting the calculated tifs, default is TRUE}

\item{sagaLinks}{list. SAGA tools cli paths}

\item{gdalLinks}{list. GDAL tools cli paths}

\item{otbLinks}{list. OTB tools cli paths}
}
\value{
data frame containing for each drawn point the pixel values of the rasterstack data
}
\description{
Convenient function to preprocess synthetic raster bands from a given RGB image and/or DTM/DSM data.
Currently for all chanels of the input images the following textures and indices can be calculated:\cr
rgb indices (17), color transformation (9), haralick (3 = 25 layers), statitics (4),edge (3),morpho (4), DEM Parameter (20).
All layers will be stacked (as an ENVI file). 
If wanted the raster values can be extracted to a data frames by overlaying corresponding vector data. NOTE: The vector data has to be named identically to the rasterfiles.  This is useful
for for classification training purposes and covers usually step 1 of the random forest based
classification of UAV derived visible imagery and point clouds.
}
\details{
(01) calc_ext() calculation of spectral indices, basic spatial statistics and textures and
              extracting of training values over all channels according to training data\cr\cr
(02) ffs_train() training using random forest and the forward feature selection method \cr
                     startTrain=TRUE\cr\cr
(03) calc_ext() with respect to the selected predictor variables you may calculate
              the requested channels for all rgb data that you want to predict.\cr\cr
(04) prediction startPredict=TRUE\cr\cr
}
\note{
If the function is used for stand alone extraction of the training data please provide both, the imagestack containing the raster data plus the corresponding band names (usually saved as an Rdata file) and the corresponding shape file.

The workflow is intended to use the forward feature selection as decribed by \href{https://www.sciencedirect.com/science/article/pii/S1364815217310976}{Meyer et al. (2018)}.
This approach needs at least a pair of images that differ in time and/or space for a leave one location out validation mode. You may overcome this situation if you tile your image and provide for each tile seperate training data.
If you just want to classify a single image by a single training file use the normal procedure as provided by the \code{\link[caret]{trainControl}} function.
}
\examples{

\dontrun{

require(uavRst)
require(link2GI)

# create and check the links to the GI software
sagaLinks<-link2GI::linkSAGA()
gdalLinks<-link2GI::linkGDAL()
otbLinks<-link2GI::linkOTB()


##- create and set folders
##- please mind that the pathes are exported as global variables
paths<-link2GI::initProj(projRootDir = tempdir(),
                         projFolders = c("data/","data/ref/","output/","run/","las/"),
                         global = TRUE,
                         path_prefix = "path_")
  
##- clean runtime folder
unlink(file.path(tempdir(),"*"), force = TRUE)
  
##- get the tutorial data
url<-"https://github.com/gisma/gismaData/raw/master/uavRst/data/tutorial_data.zip"
utils::download.file(url,
                       file.path(tempdir(),"tutorial_data.zip"))
unzip(zipfile = file.path(tempdir(),"tutorial_data.zip"), 
                          exdir = R.utils::getAbsolutePath(path_run))
  
  ##- calculate some synthetic channels from the RGB image and the canopy height model
  ##- then extract the from the corresponding training geometries the data values aka trainingdata
  trainDF <- calc_ext(calculateBands    = TRUE,
                      extractTrain      = TRUE,
                      suffixTrainGeom   = "",
                      patternIdx        = "index",
                      patternImgFiles   = "rgb" ,
                      patterndemFiles   = "chm",
                      prefixRun         = "tutorial",
                      prefixTrainImg    = "",
                      rgbi              = TRUE,
                      indices           = c("TGI","CI"),
                      channels          = c("red"),
                      rgbTrans          = TRUE,
                      hara              = TRUE,
                      haraType          = c("simple"),
                      stat              = TRUE,
                      edge              = TRUE,
                      morpho            = TRUE,
                      pardem            = TRUE,
                      #demType           = c("slope", "MTPI"),
                      kernel            = 3,
                      currentDataFolder = path_run,
                      currentIdxFolder  = path_run,
                      sagaLinks = sagaLinks,
                      gdalLinks = gdalLinks,
                      otbLinks =otbLinks)
  

##- show the result
head(trainDF)

# use ffs_train as next step for rf classification issues

}
}
