% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_classify.R
\name{get_traindata}
\alias{get_traindata}
\title{Extracts training data from a raster stack using vector data as a mask.}
\usage{
get_traindata(rasterStack = NULL, trainPlots = NULL)
}
\arguments{
\item{rasterStack}{an object of rasterstack*. containing image data to make prediction on}

\item{trainPlots}{an object of SpatialPolygonDataFrame*. providing the training areas}
}
\value{
data frame with either the raster stack of all trainingn data and/or the data frame containing the training data vlaues of given training areas
}
\description{
Extracts training data from a raster stack and returns a dataframe containing for each pixel all values.
}
\examples{
\dontrun{
##- required packages
require(uavRst)
setwd(tempdir())

##- get the tutorial data
utils::download.file("https://github.com/gisma/gismaData/raw/master/uavRst/data/tutorial_data.zip",
                     "tutorial_data.zip")
unzip("tutorial_data.zip",exdir =  ".")

##- get the files
imageTrainStack <- list()
geomTrainStack <- list()
imageTrainFiles <- Sys.glob("rgb??.tif")
geomTrainFiles <- Sys.glob("rgb??.shp")

##- create stacks from image and geometry files
imageTrainStack<-lapply(imageTrainFiles, FUN=raster::stack)
geomTrainStack  <- lapply(geomTrainFiles, FUN=raster::shapefile)
names(imageTrainStack[[1]])<-c("red","green","blue")
names(imageTrainStack[[2]])<-c("red","green","blue")
names(imageTrainStack[[3]])<-c("red","green","blue")

##' finally extraxt the training data to a data frame
trainDF <- get_traindata(rasterStack  = imageTrainStack,
                        trainPlots = geomTrainStack)

##- have a look at the training data
head(trainDF)
}
}
\author{
Chris Reudenbach
}
