% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_textures.R
\name{otbtex_edge}
\alias{otbtex_edge}
\title{Calculates edges for a given kernel size.}
\usage{
otbtex_edge(
  input = NULL,
  out = "edge",
  ram = "8192",
  filter = "gradient",
  touzi_xradius = 1,
  touzi_yradius = 1,
  channel = NULL,
  retRaster = FALSE,
  outDir = NULL,
  verbose = FALSE,
  otbLinks = NULL
)
}
\arguments{
\item{input}{of GeoTiff containing 1 ore more gray value band(s)}

\item{out}{the output mono band image containing the edge features}

\item{ram}{reserved memory in MB}

\item{filter}{the choice of edge detection method (gradient/sobel/touzi)}

\item{touzi_xradius}{x radius of the Touzi processing neighborhood (if filter==touzi) (default value is 1 pixel)}

\item{touzi_yradius}{y radius of the Touzi processing neighborhood (if filter==touzi) (default value is 1 pixel)}

\item{channel}{sequence of bands to be processed}

\item{retRaster}{boolean if TRUE a raster stack is returned}

\item{outDir}{output Directory}

\item{verbose}{switch for system messages default is FALSE}

\item{otbLinks}{list. of GI tools cli pathes}
}
\value{
raster* object
}
\description{
Calculates edges for a given kernel size. return list of geotiffs containing thelocal statistics for each channel
}
\note{
the otb is used for filtering. please provide a GeoTiff file
}
\examples{
\dontrun{
# required packages
# load libraries
require(uavRst)
require(link2GI)
require(listviewer)

setwd(tempdir())

# check if OTB exists
otbLinks <- link2GI::linkOTB()

if (otbLinks$exist) {
data("rgb")
raster::plotRGB(rgb)
fn<-file.path(tempdir(),"rgb.tif")
raster::writeRaster(rgb, 
                    filename=fn,
                    format="GTiff", 
                    overwrite=TRUE)
# get help
cmd<-link2GI::parseOTBFunction(algo = "EdgeExtraction",gili=otbLinks)
listviewer::jsonedit(cmd$help)

# calculate Sobel edge detection
  r<-otbtex_edge(input=fn,
                 filter="sobel",
                 retRaster = TRUE,
                 otbLinks = otbLinks)

# visualize all layers
  raster::plot(r[[1]])
}
}
}
\author{
Chris Reudenbach
}
