% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_pc_2D_dsm.R
\name{pc_2D_dsm}
\alias{pc_2D_dsm}
\title{Create a Digital Terrain Model from UAV generated point clouds by minimum altitude sampling}
\usage{
pc_2D_dsm(
  laspcFile = NULL,
  gisdbasePath = NULL,
  grassVersion = 1,
  searchPath = NULL,
  sampleMethod = "max",
  threshold = 20,
  cutExtent = NULL,
  targetGridSize = 0.25,
  projFolder = NULL,
  proj4 = "+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs",
  giLinks = NULL,
  verbose = FALSE
)
}
\arguments{
\item{laspcFile}{character. default is \code{NULL} path  to the laz/las file(s)}

\item{gisdbasePath}{character. default is \code{NULL} root directory of the project. NOTE the function creates two subfolder named \code{run} and \code{output}}

\item{grassVersion}{numeric. version of GRASS as derived by findGRASS() default is 1 (=oldest/only version) please note GRASS version later than 7.4 is not working with r.inlidar}

\item{searchPath}{path to look for grass}

\item{sampleMethod}{sampling method for point aggregation}

\item{threshold}{numeric. percentile threshold}

\item{cutExtent}{clip area}

\item{targetGridSize}{numeric. the resolution of the target DTM raster}

\item{projFolder}{subfolders that will be created/linked for R related GRASS processing}

\item{proj4}{character. valid proj4 string that should be assumingly the correct one}

\item{giLinks}{list of link2GI cli pathes, default is NULL}

\item{verbose}{to be quiet (1)}
}
\value{
raster* object
}
\description{
Create a Digital Surface Model from a high density point cloud as typically derived by an
optical UAV retrieval. It simply samples the maximum or whatever values of a given target
grid size and fills the no data holes if so.
}
\examples{
\dontrun{
require(uavRst)
require(link2GI)

# create and check the links to the GI software
giLinks<-list()
giLinks$grass<-link2GI::linkGRASS7(returnPaths = TRUE)
if (giLinks$grass$exist) {

# proj subfolders
projRootDir<-tempdir()
unlink(paste0(projRootDir,"*"), force = TRUE)
paths<-link2GI::initProj(projRootDir = projRootDir,
                         projFolders = c("data/","data/ref/","output/","run/","las/"),
                         global = TRUE,
                         path_prefix = "path_")
# get some colors
pal = mapview::mapviewPalette("mapviewTopoColors")

# get the data
utils::download.file(url="https://github.com/gisma/gismaData/raw/master/uavRst/data/lidar.las",
destfile="lasdata.las")

# create 2D pointcloud DSM
dsm <- pc_2D_dsm(laspcFile = "lasdata.las",
                gisdbasePath = projRootDir,
                sampleMethod = "max",
                targetGridSize = 0.5,
                giLinks = giLinks)
                }
 raster::plot(dsm)
}
}
\author{
Chris Reudenbach
}
