% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitFig.R
\name{knitFig}
\alias{knitFig}
\title{Easily knit a custom figure fragment}
\usage{
knitFig(plotToDraw, template = getOption("ufs.knitFig.template", NULL),
  figWidth = getOption("ufs.knitFig.figWidth", 16/2.54),
  figHeight = getOption("ufs.knitFig.figHeight", 16/2.54),
  figCaption = "A plot.", chunkName = NULL, returnRaw = FALSE,
  catPlot = getOption("ufs.knitFig.catPlot", FALSE), ...)
}
\arguments{
\item{plotToDraw}{The plot to draw, e.g. a \code{\link{ggplot}} plot.}

\item{template}{A character value with the \code{\link{knit_expand}}
template to use.}

\item{figWidth}{The width to set for the figure (in inches).}

\item{figHeight}{The height to set for the figure (in inches).}

\item{figCaption}{The caption to set for the figure.}

\item{chunkName}{Optionally, the name for the chunk. To avoid problems
because multiple chunks have the name "\code{unnamed-chunk-1}", if no chunk
name is provided, \code{\link[digest:digest]{digest::digest()}} is used to generate an MD5-hash from
\code{\link{Sys.time}}.}

\item{returnRaw}{Whether to \code{\link[=cat]{cat()}} the result (\code{TRUE}) or whether
to return it as \code{\link[knitr:asis_output]{knitr::asis_output()}} object (\code{FALSE}).}

\item{catPlot}{Whether to use the \code{\link[base:cat]{base::cat()}} function to print the
code for the plot, and return the result invisibly. If not, the result is
returned visible, and so probably printed anyway.}

\item{\dots}{Any additional arguments are passed on to
\code{\link{knit_expand}}.}
}
\value{
This function returns nothing, but uses \code{\link{knit_expand}}
and \code{\link{knit}} to \code{\link{cat}} the result.
}
\description{
THis function was written to make it easy to knit figures with different, or
dynamically generated, widths and heights (and captions) in the same chunk
when working with R Markdown.
}
\examples{
\donttest{knitFig(ggBoxplot(mtcars, 'mpg'))}
}
\seealso{
\code{\link{knit_expand}} and \code{\link{knit}}
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
\keyword{utilities}
