% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{expand_date}
\alias{expand_date}
\title{Generate Temporal Identifiers from a Date Column}
\usage{
expand_date(
  x,
  gen = c("Year", "Quarter", "FY", "QFY", "Month"),
  origin = "1899-12-30",
  keep.date = TRUE,
  remove.missing.date = TRUE,
  sort = TRUE,
  as.factor = TRUE,
  ...
)
}
\arguments{
\item{x}{either a vector of class 'Date', or coercible to date using \code{\link{as.Date}}, or a data frame / list with a date variable in the first column.}

\item{gen}{character. A vector of identifiers to generate from \code{x}. The possible identifiers are found in \code{\link{.Tvars}}. The default setting is to generate all identifiers apart from 'Day'.}

\item{origin}{character / Date. Passed to \code{\link{as.Date}}: for converting numeric \code{x} to date.}

\item{keep.date}{logical. \code{TRUE} will keep the date variable in the first column of the resulting dataset, \code{FALSE} will remove the date variable in favor of the generated identifiers.}

\item{remove.missing.date}{logical. \code{TRUE} will remove missing values in \code{x}. If \code{x} is a dataset, the corresponding rows will be removed.}

\item{sort}{logical. \code{TRUE} will sort the data by the date column.}

\item{as.factor}{\code{TRUE} will generate quarters, fiscal years and months ('Quarter', 'FY', 'QFY', 'Month') as factor variables. It is also possible to use \code{as.factor = "ordered"} to generate ordered factors.
\code{FALSE} will generate fiscal years as character and quarters and months as integer variables.}

\item{\dots}{not used.}
}
\description{
This function expands a date column and generates additional temporal identifiers from it (such as the year, month, quarter, fiscal year etc.).
}
\examples{
# First a basic example
x <- seq.Date(as.Date("1999-01-01"), as.Date("2000-01-01"), by = "month")
expand_date(x)
expand_date(x, gen = c("Year", "Month"), keep.date = FALSE)
\donttest{
# Now using the API
expand_date(get_data("BOU_CPI")) # Getting Monthly CPI data from the Bank of Uganda

# Same thing
get_data("BOU_CPI", expand.date = TRUE)
}

}
\seealso{
\code{\link{make_date}}, \code{\link{ugatsdb}} % \code{\link{times}},
}
