% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{wide2excel}
\alias{wide2excel}
\title{Export Wide Data to Excel}
\usage{
wide2excel(data, ..., transpose = FALSE, transpose.date.format = "\%m/\%d/\%Y")
}
\arguments{
\item{data}{a wide dataset from \code{\link{get_data}} or reshaped to a wide format with \code{\link{long2wide}}.}

\item{\dots}{further arguments to \code{\link{write_xlsx}}. As a minimum a path needs to be supplied that ends with the name of the excel file. See Examples.}

\item{transpose}{logical. If \code{TRUE}, the result is returned in a row-oriented excel format. The default is column oriented (same as the dataset in R).}

\item{transpose.date.format}{argument passed to \code{\link{transpose_wide}}, setting the format of date columns when data is transposed.}
}
\description{
This function exports a wide format dataset to a column- (default) or row-oriented excel format.
}
\examples{
\dontrun{
# Getting macroeconomic indicators from Bank of Uganda in fiscal years
data <- get_data("BOU_MMI_FY", from = "2000/01")

# Saving to different excel formats
wide2excel(data, "BOU_MMI_FY.xlsx")
wide2excel(data, "BOU_MMI_FY.xlsx", transpose = TRUE)

# Saving to alternative path
wide2excel(data, "C:/Users/.../BOU_MMI_FY.xlsx")
}

}
\seealso{
\code{\link{transpose_wide}}, \code{\link{write_xlsx}}, \code{\link{transpose}}, \code{\link{ugatsdb}}
}
