% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readwrite.R
\name{ukb_gen_read_fam}
\alias{ukb_gen_read_fam}
\title{Reads a plink format fam file}
\usage{
ukb_gen_read_fam(file, col.names = c("FID", "IID", "paternalID", "maternalID",
  "sex", "phenotype"), na.strings = "-9")
}
\arguments{
\item{file}{A path to a fam file.}

\item{col.names}{A character vector of column names. Default: c("FID", "IID", "paternalID", "maternalID", "sex", "phenotype")}

\item{na.strings}{Character vector of strings to use for missing values. Default "-9". Set this option to character() to indicate no missing values.}
}
\description{
This is wrapper for read_table that reads a basic plink fam file. For plink hard-called data, it may be useful to use the fam file ids as a filter for your phenotype and covariate data.
}
\seealso{
\code{\link{ukb_gen_read_sample}} to read a sample file
}
