% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_bets.R
\name{effective_bets}
\alias{effective_bets}
\title{Effective Number of Bets}
\usage{
effective_bets(b, sigma, t)
}
\arguments{
\item{b}{A vector of exposures (allocations).}

\item{sigma}{A \code{n x n} covariance matrix.}

\item{t}{A \code{n x n} torsion matrix.}
}
\value{
A \code{list} of length 2 with:
    \itemize{
      \item \code{p}: the diversification probability distribution;
      \item \code{enb}: the effective number of bets.
    }
}
\description{
Computes the diversification probability distribution and the effective number
of bets of an allocation.
}
\examples{
# extract the invariants from the data
set.seed(123)
log_ret <- matrix(rnorm(400), ncol = 4) / 10

# compute the covariance matrix
sigma <- stats::cov(log_ret)

# torsion
torsion_cov <- torsion(sigma = sigma, model = 'minimum-torsion', method ='exact')

# 1/N reference
b <- rep(1 / ncol(log_ret), ncol(log_ret))

# ENB
effective_bets(b = b, sigma = sigma, t = torsion_cov)
}
