% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uniprot.R
\docType{methods}
\name{getUniprotSummary}
\alias{getUniprotSummary}
\alias{getUniprotSummary,gene-method}
\title{Gather Uniprot Data}
\usage{
getUniprotSummary(x, y)

\S4method{getUniprotSummary}{gene}(x, y)
}
\arguments{
\item{x}{\code{gene} object}

\item{y}{\code{query} object (see \code{getNihQuery()})}
}
\value{
\code{gene} object - a copy of the input object 'y', having the uniprot data added.
}
\description{
\code{getUniprotSummary} collates data returned from a html request to the Uniport publicly available databases to populate the gene object.
The query currently returns id, entry name, reviewed, protein names, genes, organism, length and "comment(FUNCTION)".
}
\section{Methods (by class)}{
\itemize{
\item \code{gene}: \code{gene} object - a copy of the input object 'y', having the uniprot data added.
}}
\examples{
\dontrun{
f <- query()
f@gene <- "BRAF"
gene <- gene()
gene@name <- f@gene
gene <- getUniprotSummary(gene,f)
}
}
\seealso{
\url{http://www.uniprot.org/help/uniprotkb_column_names}
}

